	page	,132
	title  growscan - Determine how big a heap segment can grow
;***
;growscan.asm - Determine how big a heap segment can grow
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Given a heap descriptor, determine how large the corresponding
;	heap segment can grow.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

OS2_MODE	equ	1		; Protect mode

sBegin	data
	assumes ds,data

externB _osmode 			; protect/real mode

sEnd

sBegin	code

	assumes cs,code

page
;***
; growscan - Determine how big a heap segment can grow
;
;Purpose:
;	Given a heap descriptor, determine how large the corresponding
;	heap segment can grow.
;
;	[NOTE 1: This routine assumes that the supplied heap is initialized.]
;
;	[NOTE 2: __growscan() subtracts 2 from the grow size in anticipation
;	of the return value being used in the heap (the 2 leaves room for a
;	heap header.]
;
;Entry:
;	ds:bx = heap descriptor address
;
;	[***NOTE***: Currently, we assume this routine only supports the
;	near heap (so we assume ds:bx points to _nheap_desc).]
;
;Exit:
;	ax = number of bytes the heap can grow	(see NOTE 2 above).
;Uses:
;	dx
;Preserves
;	cx (_memmax currently depends on this)
;
;Exceptions:
;
;*******************************************************************************

cProc	_growscan,<PUBLIC,NEAR>,<>

cBegin	<nogen>



; Real mode
; If near heap, use DGROUP size as the max.  Else, assume we can't grow the
; segment.

	; *** FOR NOW, THIS IS ONLY CALLED FROM THE NEAR HEAP SO
	; *** WE CAN ASSUME DGROUP
	;test	[bx].flags,_HEAP_NEAR	; near heap ??
	;jnz	no_room 		; nope, assume we can't grow
	; *** END FAR HEAP SUPPORT

					; near heap so ds = DGROUP
	mov	ax,[bx-2]		; ax = asizds = size DGROUP - 1
	;fall thru


; Calculate how much we can really grow the segment
; ax = max segment size

grow_calc:
	sub	ax,2			; overhead - 2 byte header
	mov	dx,[bx].segsize 	; get current segment size
	dec	dx			; in case size = 0 (64kb)
	cmp	ax,dx			; is there room to grow ??
	jbe	no_room 		; no, can't grow
	sub	ax,dx			; grow size = max - size
	jmp	short done		; join common return
	;fall thru

;
; Cannot grow the segment - return 0
;

no_room:
	xor	ax,ax			; ax = 0
	;fall thru

;
; Common return
; ax = # of bytes segment can grow
;

done:
	ret

cEnd	<nogen>

sEnd	code

	end
