	page	,132
	title	 growseg - Grow a heap segment
;***
;growseg.asm -
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Grow a heap segment to increase the amount of space
;	available for allocations.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
ifdef _WINDOWS
include rterr.inc
endif	;_WINDOWS
include heap.inc
.list


sBegin	data
	assumes ds,data

globalW _amblksiz,_HEAP_GROWSEG 	; default heap increment size

ifndef	_WINDOWS
externW _psp				; PSP paragraph number
endif

sEnd


ifdef _WINDOWS
	extrn	__amsg_exit:near	; write error and die
ifdef	_BAT16
	externP	BatReallocSeg	; BAT16 re-size far segment
else
	extrn	GLOBALREALLOC:far	; re-size far segment
endif	; _BAT16
	extrn	GLOBALSIZE:far		; get size of segment
else
endif



ifdef	_WINDOWS
ifdef	SS_NEQ_DGROUP
externP    <_GetDGROUP> 		; Function to recover DGROUP
endif	;SS_NEQ_DGROUP
endif	;_WINDOWS

sBegin	code
	assumes cs,code

ifdef _WINDOWS
	extrn	__wflags:word		; Windows status flags
endif

page
;***
; _growseg - Grow a heap segment
;
;Purpose:
;	Grow a heap segment to increase the amount of space
;	available for allocations.
;
;	Notes:
;	(1) The caller has already determined that the block size cannot
;	be allocated in the current heap and heap segment growth is necessary.
;	(2) The size argument is the block allocation size requested
;	by the user.  The supplied size is NOT the heap increment.
;	(that size is determined by this routine).
;
;Entry:
;	ds:bx = heap segment descriptor
;	cx = size of block requested
;
;Exit:
;	Success:
;		carry = clear
;	Failure:
;		carry = set
;
;Uses:
;	es
;
;Preserves:
;	cx, di
;
;*******************************************************************************

cProc	_growseg,<PUBLIC,NEAR>,<>

cBegin	<nogen>

	push	cx			; save caller's cx
	push	di			; save caller's di

; First, see if it is legal to grow this segment.
; ds:bx = heap descriptor

	test	byte ptr [bx].flags,_HEAP_MODIFY
	jz	error_rtn		; return error if modify bit clear

; Calculate how much we need to grow the segment by to satisfy the user's
; request.
; cx = size of block requested

	call	_findlast		; si = pointer to last heap entry
	mov	di,si			; save pointer in di for later use
	mov	ax,[si] 		; length of last entry
	test	al,1			; is it free ??
	jz	calc_length		; no
	sub	cx,ax			; reduce requested length by free size
	dec	cx			; adjust for inc' below (only one dec
					; because free bit is set...)
calc_length:
	inc	cx
	inc	cx			; add header field to size

	mov	si,[bx].segsize 	; si = current size of segment
	or	si,si			; already 64 Kb ??
	jz	error_rtn		; yep, go return an error
	add	cx,si			; cx = desired new size of segment
					; (not yet rounded by _amblksiz)
	jnc	size_ok 		; legal segment size

;
; Special code to handle case of cx = 0 (i.e., requested new segment size is
; exactly 64 K). This amounts to taking a shortcut to calling _incseg.
;
	xor	ax,ax			; set newsize request to 64 Kb
	mov	dx,0FFF0h		; indicate paragraph increment
	jcxz	grow3			; shortcut!
	jmp	short error_rtn

;
; Determine the optimal heap increment size.
;
size_ok:


ifdef SS_NEQ_DGROUP
ifdef _WINDOWS
	call	_GetDGROUP
	mov	es,ax			; es = DGROUP
else
	mov	ax,DGROUP		; es = DGROUP
	mov	es,ax
endif
else
if	sizeD
	mov	ax,DGROUP		; es = DGROUP
	mov	es,ax
else
	push	ss			; es = DGROUP
	pop	es
endif
endif
	assumes es,data
	mov	ax,es:[_amblksiz]	; get increment size
	;*** OPTIMIZATION: CODE WILL WORK WITHOUT THE FOLLOWING 2 INSTRUCTIONS
	cmp	ax,_HEAP_GROWSEG	; compare to default increment
	je	grow1			; if equal, use the default
	;fall thru

;
; Compute the heap segment increment size.
; That is, 2**N, where 2**N >= _amblksiz > 2**(N-1).
; Test the values 2**(N-1), in descending order, until one is found that
; is less than _amblksiz.  Then, shift the value left to get 2**N.
; ax = _amblksiz
;

	mov	dx,8000h		; start by testing 2**15
next_size:
	cmp	dx,ax			; is current 2**(N-1) smaller?
	jb	grow			;  yep, dx = 2**(N-1)
	shr	dx,1			; di = next lower power of 2
	jnz	next_size		; try again...
	jmp	short paragraph 	; use increment size = paragraph

;
; --- grow ---
; Try to grow the segment.
;  (1) First, try to grow the segment by the optimal size
;      (rounded up to an _amblksiz boundary).
;  (2) If that fails, try to grow by just enough to fullfill the request
;      (rounded up to a paragraph boundary).
;
;  [NOTE: We will try to grow the segment twice AT MOST.]
;
; cx = grow size necessary to fulfill caller's request
; si = current size of heap segment
;

; dx = 2**(N-1)
grow:
	cmp	dx,08h			; will increment be < paragraph ??
	jb	paragraph		; yes, use paragraph increment
	shl	dx,1			; dx = 2**N (if 0, that's ok)
	mov	ax,dx			; ax = (power of 2)


; ax = heap seg increment size
grow1:
	dec	ax			; ax = (power of 2) - 1
	mov	dx,ax			; save for later
	add	ax,cx			; round up to next highest multiple
					; of (power of 2)
	jnc	grow2			; overflow ??
	xor	ax,ax			; yes, grow to max seg size (0 = 64kb)
grow2:
	not	dx			; make ((power of 2) - 1) a mask
	and	ax,dx			; ax is now rounded up

grow3:
	push	dx			; save increment mask
	call	_incseg 		; *** try to grow the segment ***
	pop	dx			; restore increment mask
	jnc	good_rtn		; Good return on success

	cmp	dx,0FFF0h		; error, was increment == paragraph ??
	je	error_rtn		; yes, no more we can do (return error)

paragraph:				; try an increment size of a paragraph
	mov	ax,10h			; ax = paragraph size
	jmp	short grow1		; try again

;
;  --- Error Return ---
;

error_rtn:
	stc				; carry set = error
	jmp	short done		; return the error

;
; --- Good Return ---
;
; We successfully grew the heap segment.
; Link the new free block into the heap and update pointers, _HEAP_END, etc.
; ax = new segment size
; ds:bx = heap descriptor
; di = pointer to previous last heap entry
;

good_rtn:
	mov	dx,ax			; dx = new size
	sub	dx,[bx].segsize 	; dx = segment increment
	mov	[bx].segsize,ax 	; update segment size field

	mov	[bx].rover,di		; rover = previous last entry (in di)

	mov	si,[bx].last		; si = pointer to old _HEAP_END
	dec	dx			; dx = length of block marked free
	mov	[si],dx 		; put length of new block in heap

	inc	dx			; dx = length of new block + header
	add	si,dx			; si = points to new end of heap
	mov	[si],_HEAP_END		; mark new end of heap
	mov	[bx].last,si		; update .last pointer
	;fall thru (not that the carry flag was cleared by the add above!)

;
; Common Return
; ax = return value
;

done:
	pop	di			; restore caller's di
	pop	cx			; restore caller's cx
	ret

cEnd	<nogen>


page
;***
; _incseg - Increment the segment
;
;Purpose:
;	This routine issues the OS call that actually grows/shrinks the
;	heap segment.
;
;	NOTE: This routine is meant for internal use only.
;
;	DOS NOTE: The 'segsize' value in the near heap descriptor
;	indicates the top of the heap, NOT the current size of DGROUP.
;	Thus, we must check the REAL size of DGROUP to see if we
;	really need to grow the heap (_asizds).   Also, growing
;	the near heap must be based on the _psp segment, not DGROUP
;
ifdef	_WINDOWS
;	WINDOWS NOTE:  Do to a Windows restirction/bug, you should not
;	grow a segment to exactly 64K in standard mode.
endif
;
;
;Entry:
;	ax = new segment size (0 indicates a segment size of 64 Kb)
;	     [***NOTE***: This value MUST be rounded up to a paragraph
;	     boundary by the caller.]
;	ds:bx = heap descriptor
;Exit:
;	Success:
;		carry = clear
;		ax = new segment size (0 indicates a segment size of 64 Kb)
;	Failure:
;		carry = set
;
;Preserves:
;	ds:bx, cx, di
;
;Uses:
;	ax, dx, si, es
;
;Exceptions:
;
;*******************************************************************************


cProc	_incseg,<PUBLIC,NEAR>,<>

cBegin	<nogen>

	mov	dx,ax			; save requested size

;
; --- Special near heap code ---
;
; Growing:  We don't have to issue a call if there's room between heap and
; _asizds.
;
; Shrinking:  If the new size is less than the current size, issue the call to
; shrink the segment.  Also, if the new size is EQUAL to the current size,
; issue the call since we want to free up unused DGROUP above the heap but
; below _asizds.  [Note: _Minseg() has already determined that an OS call is
; necessary in this case.]
;

	test	byte ptr [bx].flags,_HEAP_NEAR ; near heap descriptor ??
	jz	do_oscall1		; nope

ifdef _WINDOWS
;
; Windows near heap uses a different scheme so this code doesn't
; work and should never be called!
;
	jmp	short fatal_err 	; fatal error exit
else
	dec	dx			; dx = new segsize - 1
	mov	si,[bx].segsize 	; get current segment size
	dec	si			; cx = current segsize - 1
	cmp	dx,si			; are we shrinking the segment ??
	jbe	do_oscall		; yes, issue the system call

	cmp	[bx-2],dx		; _asizds > current segsize ??
	jae	incseg_ok		; yup, no need to issue system call

do_oscall:
	inc	dx			; nope, restore dx

endif	;_WINDOWS

; Issue the system call
; ax = dx = desired size

ifdef _WINDOWS	; --- WINDOWS Version

	; far/based heap reallocation
do_oscall1:
	push	dx		; preserve over call site
	push	cx
	push	bx

	mov	si,[bx].handle	; si = handle for current segment
	mov	bx,[__wflags]	; bx = windows flags word

	; set up seg size paramter (cx:dx)
	xor	cx,cx		; # of segments
	or	dx,dx		; is it 0 (i.e., 64K) ??
	jnz	@F		; nope, < 64K
				; yes, 64K allocation
	test	bx,WF_STANDARD	; standard mode?
	jnz	incseg_err	; yes, error (can't get 64K in standard mode)
	inc	cx		; cx:dx = 64K
@@:

	; grow the segment
	mov	ax,_HEAP_PROTECT; assume protect mode
	test	bx,WF_PMODE	; protect mode ??
	jnz	@F		; jump if so
	mov	ax,_HEAP_REAL	; no, real mode
@@:
	push	si		; handle
	push	cx		; # of full 64KB segments (hi word of long)
	push	dx		; # of bytes in final segment (low word)
	push	ax		; flags
ifdef _BAT16
	call	BatReallocSeg
else
	call	GLOBALREALLOC	; returns segment or 0 for error
endif	; _BAT16
	or	ax,ax		; error ??
	jz	incseg_err	; yup, error return
	cmp	ax,si		; handle change over this call ??
	jne	fatal_err	; Yow!

	; get seg size (windows may have rounded up)
	push	si		; block handle
	call	GLOBALSIZE	; get the block size
	or	dx,ax		; error ??
	jz	fatal_err	; ouch!!
				; ax = block size (modulo 64k)

	pop	bx		; restore registers after call site
	pop	cx
	pop	dx

else			; --- DOS Version ---

do_oscall1:
	push	bx			; save heap descriptor
	push	cx			; save cx value
	mov	si,ds			; es = si = heap segment
	mov	es,si
	mov	cl,4			; cl = shift count
	shr	ax,cl			; ax = paragraph count
	jnz	do_oscall2		; if ax != 0, use it
	mov	ax,1000h		; if ax == 0, set it to 1000h
					; paragraphs (i.e., 64 KB)

do_oscall2:
	test	byte ptr [bx].flags,_HEAP_NEAR ; near heap descriptor ??
	jz	do_oscall3		; nope, issue the system call

	; use _psp segment, not DGROUP
	add	ax,si			; yes, add in DGROUP seg
	mov	bx,[_psp]		; PSP base
	sub	ax,bx			; subtract PSP base
	mov	es,bx			; es = PSP base

do_oscall3:				; ax = new size (para) / es = heap seg
	mov	bx,ax			; bx = new segment size (para)
	callos	setmem			; set the heap segment size
	pop	cx			; restore cx
	pop	bx			; restore heap descriptor
	jc	incseg_done		; error - carry is set
	;fall thru

endif		; _WINDOWS else

;
; --- Good return ---
;
	mov	ax,dx			; return size
	test	byte ptr [bx].flags,_HEAP_NEAR ; near heap descriptor ??
	jz	incseg_ok		; nope, return

	; Near heap so update _asizds.
	; Use offset from _nheap_desc so DLL will work
	dec	dx			; dx = dgroup - 1
	mov	[bx-2],dx		; update _asizds
incseg_ok:				; ax = new seg size
	clc				; carry clear on success
	jmp	short incseg_done	; common return

ifdef _WINDOWS
;
; --- Fatal error ---
;

fatal_err:
	mov	ax,_RT_HEAP		; Unexpected heap error
	jmp	__amsg_exit		; fatal error handler
endif

;
; --- Error return ---
;

incseg_err:

ifdef _WINDOWS
	pop	bx			; restore registers
	pop	cx
	pop	dx
endif
	stc				; carry set on error
	;fall thru

;
; --- Common return ---
;

incseg_done:
	ret

cEnd	<nogen>



page
;***
; _findlast - Find the last entry in a heap descriptor segment
;
;Purpose:
;	Given a heap descriptor, return a pointer to the last
;	entry in that heap segment.
;
;Entry:
;	ds:bx = heap segment descriptor
;
;Exit:
;	si = pointer to header of last entry in that segment
;
;Uses:
;	ax
;
;Preserves:
;	bx, cx, dx, di, ds, es
;
;Exceptions:
;
;*******************************************************************************

cProc	_findlast,<PUBLIC,NEAR>,<>

cBegin	<nogen>

	push	di		; save caller's di

	mov	si,[bx].rover	; si = rover pointer
	cmp	si,[bx].last	; does .rover = .last?
	jne	lastloop	;   no, go begin search
	mov	si,[bx].start	; yes, must begin search at .start
	; fall thru

lastloop:
	lodsw			; ax = size of heap entry
	cmp	ax,_HEAP_END	; end of heap ??
	je	lastdone	; yup, finish up
	mov	di,si		; save current pointer
	and	al,not 1	; nope, mask off free/use bit
	add	si,ax		; si = pointer to next entry
	;jc	heaptoast	; *** error, heap is toasty... ***
	jmp	short lastloop	; try next one

lastdone:			; found the end
	dec	di
	dec	di		; back up saved pointer to header
	mov	si,di		; si = pointer to last heap entry header

	pop	di		; restore caller's di
	ret

cEnd	<nogen>


sEnd	code

	end
