/***
*handler.cxx - defines C++ setHandler routines
*
*	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Defines C++ setHandler routines
*
*******************************************************************************/

#include <internal.h>
#include <malloc.h>
#include <os2dll.h>
#include <sizeptr.h>
#include <new.h>

#if ((!defined _NEAR_NEW_) && (!defined _FAR_NEW_) && (!defined _HUGE_NEW_) && (!defined _BASED_NEW_))
#error No memory model defined.
#endif

#ifdef	_NEAR_NEW_
    _PNH _set_nnew_handler( _PNH pnh )
    {
    _PNH     pnhOld;

	pnhOld = _pnhNearHeap;
	_pnhNearHeap = pnh;

	return pnhOld;
    }

    #ifndef  SIZED
	// Define defaults if small data.
	_PNH _set_new_handler( _PNH pnh )
	{
	    return _set_nnew_handler( pnh );
	}
    #endif  // not SIZED
#endif	// _NEAR_NEW_


#ifdef	_FAR_NEW_
    _PNH _set_fnew_handler( _PNH pnh )
    {
    _PNH     pnhOld;

	pnhOld = _pnhFarHeap;
	_pnhFarHeap = pnh;

	return pnhOld;
    }

    #ifdef  SIZED
	// Define defaults if large data.
	_PNH _set_new_handler( _PNH pnh )
	{
	    return _set_fnew_handler( pnh );
	}
    #endif  // SIZED
#endif	// _FAR_NEW_


#ifdef	_HUGE_NEW_
    _PNHH _set_hnew_handler( _PNHH pnhh )
    {
    _PNHH    pnhhOld;

	pnhhOld = _pnhhHugeHeap;
	_pnhhHugeHeap = pnhh;

	return pnhhOld;
    }
#endif	// _HUGE_NEW_


#ifdef	_BASED_NEW_
    _PNHB _set_bnew_handler( _PNHB pnhb )
    {
    _PNHB    pnhbOld;

	pnhbOld = _pnhbBasedHeap;
	_pnhbBasedHeap = pnhb;

	return pnhbOld;
    }
#endif	// _BASED_NEW
