	page	,132
	title	heapadd - Add memory to heap
;***
;heapadd.asm - Add memory to heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Add a block of memory to the heap.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _nheap_desc			; near heap descriptor
externW _fheap				; far heap list

sEnd	data

externNP _addseg		; add memory to a heap segment
externNP _addlist		; add memory to linked heap list


sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;_heapadd - Add memory to the heap
;
;Purpose:
;	Add supplied memory to the heap
;
;Entry:
;	void far * block = block of memory
;	size_t blocksize  = size of block
;
;Exit:
;	ax =  0 = success
;	   = -1 = failure
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
cProc	_heapadd,<PUBLIC>,<si,di>


	parmD	block		; far pointer to block of memory
	parmW	blocksize	; size of block

cBegin

;
; Validate input values
;

	les	si,[block]		; es:si = block
	test	si,1			; is it even ??
	jnz	error_rtn		; nope - error
	mov	cx,[blocksize]		; cx = block size
	test	cl,1			; is it even ??
	jz	add_block		; yes, continue
	;fall thru			; nope - error

;
; --- Error return
;

error_rtn:
	mov	ax,-1			; ax = -1 = error
	jmp	short done		; join common return

;
; See if we should add this memory to the near or far heap
; es:si = new block
; cx = size
;

add_block:
	mov	ax,ds			; ax = dgroup
	mov	dx,es			; ds = supplied segment
	cmp	ax,dx			; new block in dgroup ??
	je	add_nheap		; yes, add to near heap
	;fall thru			; no, add to far heap

;
; Add block of memory to far heap
; es:si = new memory block
; cx = size
; ds = dgroup
;

add_fheap:
ifdef	_LOAD_DGROUP
	mov	bx,DGROUP		; ds = library's DGROUP
	mov	ds,bx
endif	;_LOAD_DGROUP
	mov	bx,dataoffset _fheap	; ds:bx = far heap list header
	call	_addlist		; add block to list
	jc	error_rtn		; error
	jmp	short good_rtn		; good return

;
; Add block of memory to near heap
; si = new memory block
; cx = size
; es = ds = dgroup
;

add_nheap:
ifndef _LOAD_DGROUP
	mov	bx,dataoffset _nheap_desc ; ds:bx = near heap descriptor
endif	;_LOAD_DGROUP
	call	_addseg 		  ; add block to heap
	jc	error_rtn		  ; error
	;fall thru			  ; good return

;
; --- Good return
;

good_rtn:
	xor	ax,ax			; ax = 0 = good return
	;fall thru

done:

cEnd	<nolocals>

sEnd	code

	end
