	page	,132
	title	initseg - Initialize a heap segment
;***
; initseg.asm - Initialize a heap segment
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
; Purpose
;	Contains _initseg(), the initializer routine for a far heap segment.
;
; Revision History:
;	03-14-88  GJF	Module created
;	03-15-88  JCR	Changed interface from stack to registers
;	05-24-88  JCR	.last points to _HEAP_END now
;	05-26-88  GJF	Tuning
;	06-01-88  GJF	Offset of descriptor must be added to size of block
;			to get the true segment size.
;	11-27-89  GJF	Fixed copyright
;
;***************************************************************************

include version.inc
.xlist
include cmacros.inc
include heap.inc
.list

; Validate the assumptions we make about the heap segment descriptor.
; All pointers must be contiguous.

.ERRE	start+2 	EQ	rover
.ERRE	rover+2 	EQ	last
.ERRE	last+2		EQ	nextseg
.ERRE	nextseg+4	EQ	prevseg


sBegin	code

	assumes cs,code

page
;***
; _initseg - Initialize a heap segment
;
; Purpose:
;
; This routine does most of the initialization for a heap segment. More
; specifically, it sets up the end of heap marker, the one allocation block,
; and initializes the start, rover, last, nextseg and prevseg fields of the
; heap segment descriptor.
;
; Entry:
;	ds:bx	= pointer to the heap segment descriptor
;	ax	= size of block available for heap (usually segment size)
;		  (must be at least _HEAP_MINSEG in length)
;
; Exit:
;	End-of-heap marker set; one allocation block set; [pdesc].start
;	and [pdesc].rover initialized to point to the one allocation block;
;	[pdesc].last points to _HEAP_END; [pdesc].nextseg and [pdesc].prevseg
;	are initialized to NULL.
;
; Uses:
;	ax, dx, si
; Preserves:
;	ds:bx, es:di
;
; Notes:
;	This routine is extremely sensitive to the layout of the fields
;	in the _heap_seg_desc. It will almost certainly have to be rewritten
;	if any of these fields are changed or switched around.
;
;***************************************************************************

cProc	_initseg,<PUBLIC,NEAR>,<es,di>

cBegin	<nogen>

	push	es			; save caller's es
	push	di			; save caller's di

; Set the size of the segment

	mov	di,ax
	add	di,bx			; di = size of segment
	mov	[bx].segsize,di 	; size of segment
	dec	di
	dec	di			; di = pointer to end-of-heap marker

; Init some values

	sub	ax,(size _heap_seg_desc) + 2 ; ax = size of heap alloc area
					; less the eoh marker
	lea	si,[bx + size _heap_seg_desc] ; si = start of heap alloc area

; Init the heap memory (free block and _HEAP_END)

	mov	[di],_HEAP_END		; init end-of-heap marker
	mov	[bx].last,di		; init last pointer
	dec	ax			; ax = size of block (marked free)
	mov	[si],ax 		; init header for only heap block

; Init the heap descriptor

	mov	[bx].checksum,ds	; save the segment for validation

	mov	ax,si			; ax = offset of first heap entry
	mov	dx,ds			; es = heap segment
	mov	es,dx

	lea	di,[bx].start		; di = address of .start
	cld
	stosw				; start,
	stosw				; rover

	inc	di
	inc	di			; di = address of nextseg
	xor	ax,ax			; set segment pointers to NULL
	stosw				; nextseg pointer (far)
	stosw
	stosw				; prevseg pointer (far)
	stosw

	pop	di			; restore caller's di
	pop	es			; restore caller's es
	ret

cEnd	<nogen>

sEnd	code
	end
