	page	,132
	title	 linkseg - Link in a heap segment
;***
;linkseg.asm - Link in a heap segment
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Link a heap segment into the heap.
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	code
	assumes cs,code
	assumes es,data

page
;***
;linkseg - Link a segment into the heap
;
;Purpose:
;	Link a supplied segment into the heap
;
;Entry:
;	ds:bx = heap segment descriptor
;	es:di = data offset to heap linked list descriptor
;
;Exit:
;
;Uses:
;	ax, si
;
;Preserves:
;	ds:bx, es:di, cx, dx
;
;Exceptions:
;
;*******************************************************************************


cProc	_linkseg,<PUBLIC,NEAR>,<>

cBegin	<nogen>

;
; See if the heap is initilized yet
;

link:
	mov	ax,word ptr es:[di].startseg+2	; ax = first desc segment
	or	ax,ax			; is it 0 ??
	jnz	link1			; no, link in the new descriptor

; This is the first heap segment to be linked in.
; (NOTE: ds:[bx].nextseg/prevseg already seg to NULL)

	mov	word ptr es:[di].startseg+2,ds	; first seg desc = ds:bx
	mov	word ptr es:[di].startseg,bx
	jmp	short link2			; jump over link-in code

;
; Link the new heap descriptor into the list
;

link1:
	push	es		; save heap list segment
	les	si,es:[di].lastseg ; es:si = last heap descriptor
	assumes es,nothing
	mov	word ptr es:[si].nextseg+2,ds ; update old last segment
	mov	word ptr es:[si].nextseg,bx
	mov	word ptr ds:[bx].prevseg+2,es ; update current segment
	mov	word ptr ds:[bx].prevseg,si
	pop	es		; restore es:di = heap list header
	assumes es,data

	;fall thru

;
; Update the last and rover pointers
;

link2:
	mov	word ptr es:[di].lastseg+2,ds  ; last heap segment = ds:bx
	mov	word ptr es:[di].lastseg,bx

	mov	word ptr es:[di].roverseg+2,ds ; rover heap segment = ds:bx
	mov	word ptr es:[di].roverseg,bx
	;fall thru

;
; Return
;

done:
	ret

cEnd	<nogen>

sEnd	code

	end
