/***
*new.cxx - defines C++ new routines
*
*	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Defines new routines
*
*******************************************************************************/

#include <internal.h>
#include <malloc.h>
#include <new.h>

#if ((!defined _NEAR_NEW_) && (!defined _FAR_NEW_) && (!defined _HUGE_NEW_) && (!defined _BASED_NEW_))
#error No memory model defined.
#endif

#ifdef	_NEAR_NEW_
    void _near * operator new( unsigned int cb )
    {
	return _nmalloc( cb );
    }
#endif	// _NEAR_NEW_


#ifdef	_FAR_NEW_
    void _far * operator new( unsigned int cb )
    {
	return _fmalloc( cb );
    }
#endif	// _FAR_NEW_


#ifdef	_HUGE_NEW_
    void _huge * operator new( unsigned long ul, size_t cb )
    {
	return _halloc( ul, cb );
    }
#endif	// _HUGE_NEW_


#ifdef	_BASED_NEW_
    void _based(void) * operator new( _segment sb, size_t cb )
    {
	return _bmalloc( sb, cb );
    }
#endif	// _BASED_NEW
