	page	,132
	title	nexpand - C runtime near heap expand
;***
;nexpand.asm - near heap block expansion
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _nexpand() - expand (contract) a block in the near heap.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _nheap_desc			; near heap segment descriptor

sEnd	data


externNP _resize

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;_nexpand(void near *nheapblk, size_t newsize) - expand (contract) a block
; in the near heap
;
;Purpose:
;	Expand (contract) the specified block in the near heap to newsize. If
;	the block is successfully resized, nheapblk is returned. If not
;	successful, the block is expanded as much as possible and NULL is
;	returned. If an error occurs, NULL is returned and errno is set to
;	*** E_?????? ***.
;
;	_nmsize can be used to determine the new size
;
;	_nexpand does not change the free/inuse status of the block
;
;Entry:
;	void near *nheapblk - pointer to near heap block to be expanded + 2
;	size_t newsize	    - new size for block
;
;	CRTDLL: ds:bx = pointer to near heap descriptor
;
;Exit:
;	returns nheapblk if successful
;	returns NULL if not successful
;	errno set to *** E_?????? *** if an error occurs
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************



;--- Single thread version

cProc	_nexpand,<PUBLIC>,<si,di>


	parmW	nheapblk
	parmW	newsize

cBegin
ifndef	 _LOAD_DGROUP
	mov	bx,dataOFFSET _nheap_desc
endif	;_LOAD_DGROUP
	mov	si,[nheapblk]
	mov	cx,[newsize]
	call	_resize
	mov	ax,si
	jnc	good_return
	xor	ax,ax
good_return:
cEnd	<nolocals>

sEnd	code
	end
