	page	,132
	title	 nfreect - Calculate near freect value
;***
;nfreect.asm - Calculate near freect value
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Calculate near freect value
;
;*******************************************************************************


include version.inc
.xlist
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _nheap_desc			; near heap descriptor

sEnd	data

externNP _scanseg			; scan a heap segment
externNP _growscan			; see how big a heap seg may grow



sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;_nfreect - Calculate near freect value
;
;Purpose:
;	_nfreect() scans the near heap and determines how many times
;	a program can call _nmalloc() to allocate an "itemsize" block
;	of memory.
;
;	[NOTE: This routine assumes that the near heap is initialized.]
;
;Entry:
;	itemsize = byte size of item
;
;Exit:
;	ax = number of blocks of size "itemsize" that could be _nmalloc'd
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

labelP	<PUBLIC,_freect>

cProc	_nfreect,<PUBLIC>,<si,di>


	parmW	itemsize		; size of item

cBegin

; Go scan the segment

ifndef _LOAD_DGROUP
	mov	bx,dataoffset _nheap_desc ; ds:bx = heap descriptor
endif	;_LOAD_DGROUP
	mov	ax,[itemsize]		; ax = itemsize
	call	_scanseg		; ax = # of itemsize blocks
	mov	cx,ax			; save in cx

; Take into account how big we can grow the segment

	call	_growscan		; ax = # of bytes seg may grow
	;*** 2 INSTRUCTION OPTIMIZATION ***
	;or	ax,ax			; is it zero ??
	;jz	total			; yes, return current total
	;*** END OPTIMIZATION
	xor	dx,dx			; upper word of dividend = 0
	mov	bx,[itemsize]		; bx = itemsize
	add	bx,3			; add in 2 bytes for header
	jc	overflow		; jump if overflow
	and	bl,not 1		; round up to even boundary
	div	bx			; calc # of items at end of seg
total:
	add	ax,cx			; add in previous total
	jmp	short done		; all done

;
; Overflow on rounding
;
overflow:
	mov	ax,cx			; ax = total
	;fall thru

;
; Return
; ax = return value
;

done:

cEnd	<nolocals>

sEnd	code

	end
