	page	,132
	title	nheapchk -- Check the near heap
;***
;nheapchk.asm - Check the near heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Check the near heap.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _nheap_desc			; near heap descriptor

sEnd	data

externNP _setseg			; heap segment set routine


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;int _nheapchk(void) - Miminal validity check on the near heap
;
;Purpose:
;	Perform a minimal consistency check on the near heap.
;
;Entry:
;	<none>
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPOK 	 - completed okay
;	_HEAPEMPTY	 - near heap not initialized
;	_HEAPBADBEGIN	 - can't find initial header info
;	_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	_LOAD_DGROUP

cProc	_dll_nheapchk,<PUBLIC>,<si,di>	; ds:bx = near heap descriptor

else

ife	sizeD
labelP	<PUBLIC,_heapchk>
endif

cProc	_nheapchk,<PUBLIC>,<si,di>

endif	;_LOAD_DGROUP


cBegin

	mov	cx,_HEAPSET_NOFILL	; cx = don't fill the free blocks
	;fall through

;
; Both _nheapchk and _nheapset enter here.
; cx = fill value or _HEAPSET_NOFILL
;

common:


	mov	bx,dataoffset _nheap_desc ; ds:bx = heap descriptor
	call	_setseg 	; check/set near heap


cEnd	<nolocals>


page
;***
;int _nheapset(unsigned) - Set contents of free near heap blocks
;
;Purpose:
;	Fill all the free blocks in the near heap with the
;	supplied value.  Also, perform some heap consistency
;	checks while we're at it.
;
;Entry:
;	unsigned = fill value
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPOK 	 - completed okay
;	_HEAPEMPTY	 - near heap not initialized
;	_HEAPBADBEGIN	 - can't find initial header info
;	_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	_LOAD_DGROUP

cProc	_dll_nheapset,<PUBLIC>,<si,di>	; ds:bx = near heap descriptor

else

ife	sizeD
labelP	<PUBLIC,_heapset>
endif

cProc	_nheapset,<PUBLIC>,<si,di>

endif	;_LOAD_DGROUP

	parmW	fill			; fill value

cBegin

	mov	cx,[fill]		; cx = fill value
	jmp	short common		; join _nheapchk code

cEnd	<nogen>

sEnd	code

	end
