	page	,132
	title	nheapmin - Minimize the near heap

;***
;nheapmin.asm - Minimize the near heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains _nheapmin, the function that minimizes the near heap.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

ifndef	_WINDOWS

sBegin	data
	assumes ds,data

externW _nheap_desc			; near heap descriptor

sEnd	data


externNP _searchseg			; coalesce free blocks
externNP _minseg			; minimize a heap segment

endif	;!_WINDOWS

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;int _nheapmin(void) - Minimize the near heap
;
;Purpose:
;	Minimize the near heap segment. First, use _searchseg to coalesce the
;	free blocks. Then, call _minseg to shrink the near heap segment
;	(the caller's default data segment, DGROUP) if possible, releasing
;	the unused memory at the end of the segment to the OS.
;
;Entry:
;	CRTDLL: ds:bx = far pointer to near heap descriptor
;
;Exit:
;	return value =	0, if no error has occurred
;		     = -1, if an error has occurred (in this case, errno
;			   will have been set by one of the helper routines)
;
;Uses:
;	everything except si, di, ds
;
;Preserves:
;	si, di, ds
;
;Notes:
;	The near heap segment is never freed since the near heap descriptor
;	does not have the _HEAP_FREE flag set. No special code is required.
;
;Exceptions:
;
;*******************************************************************************



;--- Single thread version

ife	sizeD
labelP	<PUBLIC,_heapmin>
endif

cProc	_nheapmin,<PUBLIC>,<>


cBegin	<nogen>

ifdef	_WINDOWS
;
; This is a no-op in windows since the near heap makes direct
; LocalAlloc/Free system calls.  We provide this call for compatibility
; reasons.
;
	xor	ax,ax			; ax = 0 = good return
	;fall thru to "ret"

else	;!_WINDOWS

	push	si			; save caller's si
	push	di			; save caller's di

; Coalesce blocks within the segment as much as possible.

ifndef	 _LOAD_DGROUP
	mov	bx,dataOFFSET _nheap_desc
endif	;_LOAD_DGROUP
	mov	cx,_HEAP_COALESCE
	call	_searchseg

; Minimize the segment. Note that while _minseg expects es:di to be pointing
; to a heap list descriptor (and there is no such thing for the near heap),
; this pointer is referenced iff _minseg determines the heap segment can be
; unlinked and freed. This is never the case with the near heap.

	call	_minseg
	jc	error_ret
	xor	ax,ax			; return 0 to indicate success
	jmp	short done

error_ret:
	mov	ax,-1			; return -1 to indicate error

done:
	pop	di			; restore caller's di
	pop	si			; restore caller's si

endif	;_WINDOWS

	ret

cEnd	<nogen>

sEnd	code
	end
