	page	,132
	title	nheapwalk -- Walk the near heap
;***
;nheapwalk.asm - Walk the near heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list


; Make sure assumptions about values are correct
.ERRE	_FREEENTRY	EQ	0


sBegin	data
	assumes ds,data

externW  _nheap_desc			; near heap descriptor

sEnd	data

externNP _walkseg			; walk a heap segment


sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;int _nheapwalk(&_heapinfo) - Walk the near heap
;
;Purpose:
;	Get the next near heap entry (along with size and used/free
;	status).  If _heapinfo._pentry == NULL, return information
;	about the first entry in the heap.
;
;Entry:
;	&_heapinfo = address of a _heapinfo structure (possibly returned
;		by a previous call to _nheapwalk).  The contents are:
;
;		_pentry = far pointer to heap entry (could be NULL)
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Exit:
;	Return value is one of the following constants:
;
;	_HEAPEMPTY	- near heap not initialized
;	_HEAPBADBEGIN	- can't find initial header info
;	_HEAPBADNODE	- malformed node somewhere
;	_HEAPOK 	- heap ok
;	_HEAPEND	- end of heap reached
;
;	Fills in the _heapinfo structure as follows:
;
;		_pentry = far pointer to heap entry
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

ife	sizeD
labelP	<PUBLIC,_heapwalk>
endif

cProc	_nheapwalk,<PUBLIC>,<si,di>


	parmDP	address 		; address of _heapinfo struct

cBegin

ifndef	_LOAD_DGROUP
	mov	bx,dataoffset _nheap_desc ; ds:bx = heap descriptor
endif	;_LOAD_DGROUP

if sizeD
	les	di,[address]		; es:di = address of heapinfo struct
else
	mov	di,[address]		; es:di = address of heapinfo struct
	mov	ax,ds
	mov	es,ax
endif
	call	_walkseg		; let walkseg do the work

cEnd	<nolocals>

sEnd	code

	end
