	page	,132
	title	nmalloc -- C runtime near heap allocation
;***
;nmalloc.asm - near heap allocation
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _nfree(), _nmalloc() - allocate/free memory from the
;	near heap.
;
;*******************************************************************************


include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _nheap_desc			; near heap descriptor

ifdef	VARSTCK 	;--- ?varstck.obj support ---

; "Extra" stack space needed by code that adds stack to heap
_TMPSTK_ = 20 AND 0FFFEh		; must be even

extrn	_STKHQQ:word
extrn	__end:word
staticW stkbot,0			; bottom of stack
endif			;--- end ?varstck support ---

ifndef _NOTCXX_
ifndef VARSTCK
globalCP  _pnhNearHeap, 0
endif
endif

sEnd	data

externNP _searchseg			; heap segment search routine
externNP _growseg			; grow a heap segment


ifdef	VARSTCK 	;--- ?varstck.obj support ---
externNP _addseg			; add memory to a heap segment
endif			;--- end ?varstck support ---

sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;void _nfree(ptr) - free block in near heap
;
;Purpose:
;	Free a block of memory in the near heap which was allocated
;	by _nmalloc().
;
;Entry:
;	void *ptr - pointer to block to free
;
;	CRTDLL:  ds:bx = near heap descriptor
;
;Exit:
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
ifdef	VARSTCK 	;--- ?varstck.obj support ---
cProc	__nfree,<PUBLIC>,<si>
else
cProc	_nfree,<PUBLIC>,<si>
endif			;--- end ?varstck support ---


	parmW	address 	; address of heap block to be freed

cBegin

ifdef	_LOAD_DGROUP
	mov	si,bx		; save heap descriptor in si
endif
	mov	bx,address	; bx = address of block to be freed


; ***
; ANSI states that no action occurs if a NULL pointer is passed to free.
; The following code is commented out because the NULL pointer will be detected
; by the comparison with _nheap_desc.start.  If we remove the .start check,
; we MUST enable this code to be ANSI compatible.
;
;	or	bx,bx		; is it NULL ??
;	jz	_nfend		; yup - just return
; ***

ifndef	 _LOAD_DGROUP
	mov	si,dataoffset _nheap_desc ; ds:si = heap descriptor
endif	;_LOAD_DGROUP

	cmp	[si].start,bx	; address < start ??
	jae	_nfend		; *bogus* pointer, just return
	dec	bx
	dec	bx		; bx = freed block header
	or	byte ptr [bx],1 ; free heap entry

	cmp	[si].rover,bx	; rover >= freed pointer ??
	jbe	_nfend		; yes, all done
	mov	[si].rover,bx	; nope, reset rover

_nfend:

cEnd


page
;***
;void near *_nmalloc(size) - allocate a memory block in the near heap
;
;Purpose:
;	Allocates a memory block of at least size bytes in the near heap.
;	The block will be aligned for the storage of any type of object.
;
;	[NOTE: This routine assumes that the near heap is already
;	initialized (at startup).]
;
;	[MTHREAD NOTE: Multi-thread libraries do NOT support the
;	?varstck.obj functionality.  Thus, _STKHQQ can be referenced
;	directly (i.e., without using the tid data table).
;
;Entry:
;	unsigned size - size of memory block desired
;
;	CRTDLL:  ds:bx = near heap descriptor
;
;Exit:
;	returns pointer to allocated space or NULL if fails
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version
ifdef	VARSTCK 	;--- ?varstck.obj support ---
cProc	__nmalloc,<PUBLIC>,<si,di>
else
cProc	_nmalloc,<PUBLIC>,<si,di>
endif			;--- end ?varstck support ---


	parmW	incr		; unsigned int allocation size

cBegin

ifndef _NOTCXX_
ifndef VARSTCK
RetryNMalloc:
endif
endif

;
; First, make sure the requested size is not too big
;

	mov	cx,[incr]	; cx = request block size
	cmp	cx,_HEAP_MAXREQ ; cx > maximum legal request size ??
	ja	error_rtn	; nope, try to get the memory

;
; Try to get the requested block from the heap
; cx = size
;

getmem:
ifndef _LOAD_DGROUP
	mov	bx,dataoffset _nheap_desc ; ds:bx = heap descriptor
endif	;_LOAD_DGROUP
	call	_searchseg	; get block
	jnc	ndone		; if success, we're all done

;
; Did not find a suitable block in the heap.
; Try to grow the heap.
; cx = size, ds:bx = heap descriptor
;

	call	_growseg	; try to grow the segment

ifdef	VARSTCK 	;--- ?varstck.obj support ---
	jc	rob_stack	; error, try to rob the stack
else
	jc	error_rtn	; if error, return NULL
endif			;--- end ?varstck support ---

;
; We successfully grew the heap.  Try the search again.
; (Rover pointer should be in a place that makes this search efficient.)
; cx = size, ds:bx = heap descriptor
;

search:
	call	_searchseg	; search the heap segment
	jnc	ndone		; if success, take good return
	;fall thru		; error, take bad return

ifdef	VARSTCK 	;--- ?varstck.obj support ---
;
; The following code allows the near heap to use available stack
; space, if necessary.
; ds:bx = near heap descriptor
; cx = size
;

;ds = dgroup

rob_stack:
	mov	ax,[stkbot]		; stack bottom initialized ??
	or     ax,ax
	jnz	add_stack		; yes, add stack memory to heap
	mov	ax,dataoffset __end+1	; bottom of stack addr (plus 1)
	and	al,not 1		; make it even
	mov	[stkbot],ax		; init stack bottom location

; Add necessary stack memory to heap

add_stack:

	; calculate stack space needed
	mov	dx,cx			; preserve cx
	add	dx,5			; add room for 2 heap headers (4 bytes)
	and	dl,not 1		; make even

	; see if there's enough room on stack to satisfy user's request
	mov	ax,[_STKHQQ]		; get checkstack bottom
	add	ax,dx			; ax = new _STKHQQ value
	jc	error_rtn		; error
	add	ax,_TMPSTK_		; add in stack we'll need now
	jc	error_rtn		; error
	cmp	ax,sp			; overflow stack ??
	jae	error_rtn		; yup, error

	; add stack space to heap
	push	cx			; save original user request
	push	dx			; save size of stack chunk we'll need
	mov	cx,dx			; cx = size to add to stack
	mov	si,[stkbot]		; si = address of stack chunk
	call	_addseg 		; add stack chunk to heap
	pop	dx			; restore size of stack chunk
	pop	cx			; restore user's request
	jc	error_rtn		; error

	add	[stkbot],dx		; update stack bottom
	add	[_STKHQQ],dx		; update STKHQQ
	jmp	short search		; search again

endif			;--- end ?varstck support ---

;
; Error return
;

error_rtn:

ifdef  VARSTCK

	xor	ax,ax		; dx:ax = NULL
	cwd
	;fall thru to ndone

else   ;!VARSTCK

ifdef _NOTCXX_

	xor	ax,ax		; dx:ax = NULL
	cwd
	;fall thru to ndone

else	;!_NOTCXX_

ifdef _LOAD_DGROUP
	push	ds		; push caller's dgroup
	push	ds		; push caller's dgroup again
	mov	ax,DGROUP
	mov	ds,ax		; ds = lib's group
endif

	; call user near heap error handler, if any
if  sizeC
	mov	ax, word ptr (_pnhNearHeap+2)
	or	ax, word ptr (_pnhNearHeap)
	jz	errdone 	; ax = 0
else	;not sizeC
	xor	ax,ax
	cmp	(_pnhNearHeap), ax
	je	errdone 	; ax = 0
endif	;not sizeC

ifdef  _LOAD_DGROUP
	pop	ds		; ds = caller's dgroup (for user code)
endif

	push	[incr]
	call	(_pnhNearHeap)	; call user's error handler
	add	sp, 2
	; ax = error handler return value

ifdef	_LOAD_DGROUP
	mov	dx,DGROUP
	mov	ds,dx		; ds = lib's group
endif
ifdef _LOAD_DGROUP
	pop	ds		; ds = caller's dgroup
endif

	or	ax, ax		; ax = 0 ??
	jnz	RetryNMalloc	; if not, try nmalloc again

ifdef _LOAD_DGROUP
	jmp	short errdone2	; stack is already cleaned off
errdone:
	pop	ds		; clean off stack
	pop	ds		; ds = caller's dgroup
errdone2:
else	;!_LOAD_DGROUP
errdone:
endif	;!_LOAD_DGROUP

	cwd			; Set dx:ax to zero.  Fall through to ndone.

endif	;!_NOTCXX_
endif	;!VARSTCK

;
; Common exit
; (dx:ax = return value)
;

ndone:

cEnd	<nolocals>

sEnd	code

	end
