	page	,132
	title	 nmemavl - Calculate near heap free count
;***
;nmemavl.asm - Calculate near heap free count
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Calculate near heap free count
;
;*******************************************************************************


include version.inc
.xlist
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _nheap_desc			; near heap descriptor

sEnd	data

externNP _scanseg			; scan a heap segment
externNP _growscan			; scan heap growth potential


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;_nmemavl - Calculate near heap free count
;
;Purpose:
;	_nmemavl() scans the near heap and determines the total
;	number of bytes available for allocation.
;
;	[NOTE: This routine assumes that the near heap is initialized.]
;
;Entry:
;	<none>
;
;Exit:
;	ax = total number of free bytes on near heap
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

labelP	<PUBLIC,_memavl>

cProc	_nmemavl,<PUBLIC>,<si,di>


cBegin

; Scan the segment

ifndef _LOAD_DGROUP
	mov	bx,dataoffset _nheap_desc ; ds:bx = heap descriptor
endif	;_LOAD_DGROUP
	mov	ax,-1			; don't calculate _nfreect
	call	_scanseg		; dx = total free count

; Take into account how big we can grow the segment

	push	dx			; save current total
	call	_growscan		; ax = # of bytes we can grow segment
	pop	dx			; restore total
	add	ax,dx			; ax = current + potential growth

;
; Return
; ax = return value
;

done:

cEnd	<nolocals>

sEnd	code

	end
