	page	,132
	title	 nmemmax - Find the size of biggest block on near heap
;***
;nmemmax.asm - Find the size of biggest block on near heap
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Find the size of biggest block on near heap
;
;*******************************************************************************


include version.inc
.xlist
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW  _nheap_desc			; near heap descriptor

sEnd	data

externNP _scanseg			; scan a heap segment
externNP _growscan			; see how big a heap segment may grow
externNP _findlast			; find the last entry in a heap


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;_nmemmax - Find the size of biggest block on near heap
;
;Purpose:
;	_nmemmax() scans the near heap and determines the size of
;	the largest _nmalloc() block that can be allocated.
;
;	[NOTE: This routine assumes that the near heap is initialized.]
;
;Entry:
;	<none>
;
;Exit:
;	ax = size of biggest block
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

labelP	<PUBLIC,_memmax>

cProc	_nmemmax,<PUBLIC>,<>


cBegin	<nogen>

	push	si			; save caller's si
	push	di			; save caller's di

; Scan the segment

ifndef _LOAD_DGROUP
	mov	bx,dataoffset _nheap_desc ; ds:bx = heap descriptor
endif	;_LOAD_DGROUP
	mov	ax,-1			; don't calculate _nfreect
	call	_scanseg		; cx = size of biggest free block

; Take into account how big we can grow the segment.
; If last block is free, see if that block combined with the growth
; is bigger than the current winner.
; cx = size of biggest free block

	;*** NOTE: We currently depend on _growscan NOT changing cx
	;push	 cx			; save biggest block so far
	call	_growscan		; ax = # of unused bytes after heap
	;pop	 cx			; restore biggest so far
	or	ax,ax			; potential growth = 0 ??
	jz	compare 		; yes, skip over findlast code

	push	ax			; save ax
	call	_findlast		; si = pointer to last heap entry
	pop	ax			; restore ax
	mov	dx,[si] 		; length of last entry
	test	dl,1			; is it free ??
	jz	compare 		; no, use ax as is
	dec	dx			; dx = length
	add	ax,dx			; ax = last block + potential growth
	add	ax,2			; Only 1 header needed (growscan adds 2
					; to account for potential header)
compare:
	cmp	ax,cx			; new size > old size ??
	ja	done			; yes, return new size
	mov	ax,cx			; no, return old size
	;fall thru

;
; Return
; ax = return value
;

done:
	pop	di			; restore caller's di
	pop	si			; restore caller's si
	ret

cEnd	<nogen>

sEnd	code

	end
