	page	,132
	title	nrealloc - Reallocate a near heap block to a new size

;***
;nrealloc.asm - Reallocate a block in the near heap to a new size.
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _nrealloc() - reallocate a block in the near heap to a
;	new size.
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

sBegin	data
	assumes ds,data

externW _nheap_desc

sEnd	data

externP  _nmalloc
externP  _nfree

externNP _resize

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;void near *_nrealloc(void near *nheapblk, size_t newsize)
;
;Purpose:
;	Change the size of the specified block in the near heap. First try
;	to resize the block in place (i.e., expand/contract it to newsize).
;	If this fails, try to allocate a new block of size newsize, copy
;	over the contents of the old block and free the old block.
;
;Entry:
;	void near *nheapblk - pointer to block in the near heap + 2 (i.e.,
;			      pointer to the allocation area of a block)
;	size_t newsize	    - desired new size of the block
;
;	CRTDLL: ds:bx = near heap descriptor
;
;Exit:
;	returns pointer to the new, or newly resized, block if successful
;	returns NULL if not successful, in the case the original block is
;	not altered
;
;Exceptions:
;
;*******************************************************************************


;--- Single thread version

cProc	_nrealloc,<PUBLIC>,<si,di>


	parmW	nheapblk
	parmW	newsize

cBegin
	mov	si,[nheapblk]
	mov	cx,[newsize]

; nheapblk == NULL is a special case: to conform with ANSI, the semantics are
; identical to _nmalloc(newsize).

	or	si,si			; NULL pointer?
	jz	do_nmalloc		;   yes, go allocate a new block

; nheapblk != NULL, newsize == 0 is another special case: to conform with
; ANSI, the semantics are to _nfree the block and return NULL.

	jcxz	do_nfree		;   newsize is 0, go free the block

	push	[si-2]			; save original header on stack

; First try resizing the original block. Note that if newsize <= original size
; of the block, this always works.

ifndef	_LOAD_DGROUP
	mov	bx,dataOFFSET _nheap_desc
endif	;_LOAD_GROUP
	push	cx
	call	_resize
	pop	cx
	jc	try_nmalloc		; failed, go try to get a new block
	mov	ax,si			; return nheapblk
	and	byte ptr [si-2],not 1	; make sure block is marked inuse
	pop	cx			; clean up stack
	jmp	short done

; try_nmalloc
; Try to allocate a new block of the specified size. If successful, copy the
; contents of the old block to the new block and free the old block.

try_nmalloc:
	push	bx			; save dataOFFSET _nheap_desc
	push	cx

	callcrt _nmalloc

	pop	cx			; clean up stack
	pop	bx			; restore dataOFFSET _nheap_desc
	pop	cx			; retrieve original header
	and	cl,not 1		; cx = size of original block
	or	ax,ax			; was _nmalloc successful?
	jz	failure 		;   no, go clean up and fail
	mov	di,ax			; set up to copy block contents
	mov	ax,ds
	mov	es,ax			; es = ds = DGROUP
	cld
	push	di			; save pointer to new block + 2
	push	si			; save pointer to original block + 2
	shr	cx,1
	rep	movsw			; move (original block size)/2 words

	callcrt _nfree			; free original block

	pop	cx			; clean off arg to _nfree
	pop	ax			; ax = pointer to new block + 2
	jmp	short done

; failure
; Resizing and allocating have both failed. Restore the block to its original
; size and return NULL.

failure:
	call	_resize 		; restore original block size
	xor	ax,ax			; return NULL to indicate failure
	jmp	short done		; cEnd will clean up stack

; Special case handling mandated by ANSI.

do_nmalloc:
	push	cx

	callcrt _nmalloc

	pop	cx			; clean up stack
	jmp	short done

; Special case handling mandated by ANSI.

do_nfree:
	push	si

	callcrt _nfree

	pop	cx			; clean up stack
	xor	ax,ax

done:
cEnd	<nolocals>

sEnd	code
	end
