	page	,132
	title	 scanseg - Return info on a heap segment
;***
; scanseg.asm - Return info on a heap segment
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Scan a heap segment and return info about the free portion.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

externNP	_searchseg	; validate a heap descriptor header

sBegin	code

	assumes cs,code


page
;***
; _scanseg - Return info on a heap segment
;
;Purpose:
;	Scan through a heap segment and return information about
;	the free blocks.
;
;	[NOTE 1: If input <ax> is -1, then we don't calculate the
;	number of itemsize chunks available for malloc'ing.  However,
;	we MUST return <ax>=0 so that if the user issues _freect(-1),
;	we return the correct value.]
;
;	[NOTE 2: Scanseg assumes that the heap is initialized.]
;
;Entry:
;	ax = item size (-1 means don't calculate it)
;	ds:bx = heap descriptor address
;
;Exit:
;	ax = number of "itemsize" chunks available
;	cx = size of biggest free block
;	dx = total number of free bytes available for allocation
;
;	ds:bx = unchanged
;
;	NOTE: The above return values are meant to coincide with
;	the following heap routines:
;
;		freect=ax, _memmax=cx, _memavl = dx
;
;Uses:
;	si, di, es
;
;Exceptions:
;
;*******************************************************************************

cProc	_scanseg,<PUBLIC,NEAR>,<>

cBegin	<nogen>

	push	bx			; save caller's bx

; Coalesce the free blocks of the segment

	push	ax			; save itemsize
	mov	cx,_HEAP_COALESCE	; size = special coalesce value
	call	_searchseg		; coalesce the heap segment

; Initialize registers

	mov	si,[bx].start		; si = start of heap
	pop	bx			; bx = itemsize

	cld				; scan forward

	xor	cx,cx			; cx = biggest chunk so far
	xor	dx,dx			; dx = total free bytes
	xor	di,di			; di = number of itemsize blocks

	cmp	bx,-1			; calculate itemsize count ??
	je	check_block		; nope - start the loop
	add	bx,3			; yes, add 2-byte header to itemsize
	and	bl,not 1		; and round up to even size
	jmp	short check_block	; jump into the loop

; Scan through the heap looking for free blocks and keeping stats

next_block:				; validate the next block
	cmp	ax,_HEAP_END		; are we at the end ??
	je	done			; yup, all done
	add	si,ax			; no, bump pointer to next block
	;jc	heap_toast		; *** internal consistency error ***

check_block:				; get the header from this block
	lodsw				; ax = block header
	test	al,1			; is it free ??
	jz	next_block		; no, onto next block

	; block is free - perform appropriate calculations
	dec	ax			; ax = length of free block
	add	dx,ax			; add length to free total
	cmp	ax,cx			; current block > biggest so far ??
	jb	itemsize		; no, update itemsize count
	mov	cx,ax			; yes, update biggest block
	;fall thru

	; calculate itemsize count, if necessary
itemsize:
	cmp	bx,-1			; calculate itemsize count ??
	je	next_block		; nope - onto the next block

	push	ax			; save length
	push	dx			; save total free count
	xor	dx,dx			; dx:ax = length of free block
	div	bx			; (length free block) / itemsize
	add	di,ax			; add # of itemsize blks to total (di)
	pop	dx			; restore total free count
	pop	ax			; restore length

	jmp	short next_block	; onto the next block

;
; --- Return ---
; cx = biggest block
; dx = total free count
; di = # of itemsize blocks
;

done:
	mov	ax,di			; ax = itemcount

	pop	bx			; restore caller's bx
	ret

cEnd	<nogen>

sEnd	code

	end
