	page	,132
	title	 setlist - Heap linked list check/set routine
;***
;setlist.asm - Heap linked list check/set routine
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Does a minimal heap linked list consistency check and, optionally,
;	fills all free nodes with a specified value.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include heap.inc
.list

externNP	_listchk		; validate a heap list
externNP	_setseg 		; heap segment check/set routine

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; _setlist - Heap linked list check/set routine
;
;Purpose:
;	Does a minimal heap linked list consistency check and, optionally,
;	fills all free nodes with a specified value.
;
;Entry:
;	cx = fill value (_HEAPSET_NOFILL means don't fill)
;	ds:di = dataoffset of heap linked list header
;
;Exit:
;	ax = return value as follows:
;
;		_HEAPOK 	 - completed okay
;		_HEAPEMPTY	 - near heap not initialized
;		_HEAPBADBEGIN	 - bogus header
;		_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_setlist,<PUBLIC,NEAR>,<>

	localW	RoverSegment
	localW	RoverOffset
	localW	RoverCnt

cBegin

	push	ds			; save dgroup

; Validate the heap list header (checks for empty heap, too)
; ds:di = heap list header
; cx = fill value

	mov	bx,di			; ds:bx = heap list
	call	_listchk		; validate list header
	cmp	ax,_HEAPOK		; header ok ??
	jne	done1			; nope, error or empty

;
; Init roverseg values
;
	mov	[RoverCnt],0		; zero out rover count
	les	ax,[di].roverseg	; es:ax = roverseg
	mov	[RoverSegment],es	; save roverseg
	mov	[RoverOffset],ax

;
; Loop through the linked list of heap segments checking each one.
; cx = fill value
; ds:di = heap list header
;

	; validate the first segment

	lds	bx,[di].startseg	; ds:bx = first heap segment
	assumes ds,nothing
	les	ax,[bx].prevseg 	; es:ax = ds:[bx].prevseg
	mov	si,es			; is prevseg == NULL
	or	si,ax
	jnz	badnode_rtn0		; nope, bad node

	push	di			; save linked list address

	; loop through the segments on the list

check_loop:

	;*** THIS COULD BE A MORE GENERAL TEST THAT MAKES SURE ALL
	;*** FLAGS SET IN THE HEAP HEADER FLAGS WORD ARE ALSO SET IN
	;*** EACH SEGMENT DESCRIPTOR (SEGFLAGS VS FLAGS).

	test	byte ptr [bx].flags,_HEAP_NEAR ; make sure seg not on near heap
	jnz	badnode_rtn		; oops

	call	_setseg 		; test this segment
	cmp	ax,_HEAPOK		; this segment ok ??
	jne	done2			; nope - return the value

	mov	di,ds			; di:si = current heap descriptor
	mov	si,bx

	cmp	[RoverSegment],di	; current desc == roverseg desc ??
	jne	@F
	cmp	[RoverOffset],si
	jne	@F
	inc	[RoverCnt]		; Yes - bump counter
@@:

	lds	bx,[bx].nextseg 	; get the nextseg
	mov	dx,ds			; nextseg == NULL ??
	or	dx,bx
	jz	check_last		; yes, out of loop

	les	dx,[bx].prevseg 	; es:dx = previous heap seg pointer
	cmp	dx,si			; previous pointer correct ??
	jne	badnode_rtn		; error - offset doesn't match
	mov	dx,es
	cmp	dx,di			; prevseg segment ok ??
	je	check_loop		; yes, go validate this segment
	jmp	short badnode_rtn	; error - segments don't match

;
; All heap segments are ok.
; ax = _HEAPOK
; cx = fill char
; di:si = last heap segment on chain
; tos = data offset to heap linked list header
; tos-2 = dgroup

check_last:
	pop	bx			; ds:bx = heap linked list header
	pop	ds			; (ds = dgroup)
	assumes ds,data
	les	bx,[bx].lastseg 	; es:bx = last seg on list
	cmp	si,bx			; lastseg offset correct ??
	jne	badbegin_rtn		; error - offsets don't match
	mov	bx,es
	cmp	di,bx			; lastseg segment correct ??
	jne	badbegin_rtn		; nope, error

	cmp	[RoverCnt],1		; roverseg found once?
	je	done			; yes, *** good return ***
					; ax = _HEAPOK
	;fall thru to badbegin_rtn

;
; --- Bad beginning
;

badbegin_rtn:
	mov	ax,_HEAPBADBEGIN
	jmp	short done

;
; --- Bad heap node
;

badnode_rtn:
	pop	ax			; clean off stack
badnode_rtn0:
	mov	ax,_HEAPBADNODE
	jmp	short done1

; --- Common return
; ax = return value
;

done2:
	pop	di			; clean off stack
done1:
	pop	ds			; restore ds
	assumes ds,data
done:

cEnd

sEnd	code

	end
