	page	,132
	title	 setseg - Heap segment check/set routine
;***
;setseg.asm - Heap segment check/set routine
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Does a minimal heap segment consistency check and, optionally,
;	fills all free nodes with a specified value.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include heap.inc
.list

externNP	_headchk	; validate a heap descriptor header

sBegin	code

	assumes cs,code

page
;***
; _setseg - Heap segment check/set routine
;
;Purpose:
;	Does a minimal heap segment consistency check and, optionally,
;	fills all free nodes with a specified value.
;
;Entry:
;	cx = fill value (_HEAPSET_NOFILL means don't fill)
;	ds:bx = heap descriptor
;
;Exit:
;	ax = return value as follows:
;
;		_HEAPOK 	 - completed okay
;		_HEAPEMPTY	 - near heap not initialized
;		_HEAPBADBEGIN	 - bogus header
;		_HEAPBADNODE	 - malformed node somewhere
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_setseg,<PUBLIC,NEAR>,<>

	localW	RoverCnt

cBegin

;
; --- Validate the header portion of the heap descriptor
;

	call	_headchk		; heap head check
	cmp	ax,_HEAPOK		; is it ok ?
	jne	done			; nope, all done

;
; --- Scan the heap
; Run through the heap looking for bogosity.  Also, set the free
; blocks with the 'fill value' if appropriate.
;

	; Setup for the heap scan
	cld				; scan forward

	mov	[RoverCnt],0		; clear rover flag

	push	ds			; es = heap descriptor segment
	pop	es

	mov	dx,[bx].segsize 	; dx = size of segment
	dec	dx			; in case size == 0 (i.e., 64kb)

	mov	si,[bx].start		; si = pointer to first entry
	jmp	short check_block	; jump into the fray

next_block:				; validate the next block
	add	si,ax			; no, bump pointer to next block
	jc	bad_node		; overflow = bad node
	cmp	si,dx			; new address > size of segment ??
	ja	bad_node		; yup, bad node

check_block:
	cmp	[bx].rover,si		; current header == rover?
	jne	check_block2		; nope, continue
	inc	[RoverCnt]		; yes, bump counter
check_block2:				; get the header from this block
	lodsw				; ax = block header
	cmp	ax,_HEAP_END		; are we at the end ??
	je	heap_end		; yup, end of heap

	test	al,1			; is it free ??
	jz	next_block		; no, onto next block

	; block is free - see if we should fill it
	dec	ax			; ax = length of free block
	cmp	cx,_HEAPSET_NOFILL	; should we fill it ??
	je	next_block		; no, onto next block

	; fill the free block
	push	ax			; save length for later
	push	cx			; save fill value
	shr	ax,1			; ax = word count
	xchg	ax,cx			; cx = length, ax = fill char
	mov	ah,al			; ah = al = fill char
	mov	di,si			; es:di = address of free block
	rep	stosw			; fill 'er up
	pop	cx			; cx = fill value
	pop	ax			; ax = length

	jmp	short next_block	; onto the next block

;
; --- Bad heap node return
;

bad_node:
	mov	ax,_HEAPBADNODE 	; bad heap node
	jmp	short done		; join common return

;
; --- End of Heap
; ax = _HEAP_END
; si = pointer to last entry + 2
;

heap_end:
	.ERRE	_HEAP_END EQ _HEAPOK	; Sleezy trick to save a "mov"...
	;mov	 ax,_HEAPOK		; heap is ok

	dec	si
	dec	si			; si = addr _HEAP_END
	cmp	si,[bx].last		; did we find the "real" end ??
	jne	bad_node		; nope, return an error

	cmp	[RoverCnt],1		; Did we find one and only one rover ??
	jne	bad_node		; nope, return an error

	;fall thru			; good return

;
; --- Common return
; ax = return value
;

done:

cEnd

sEnd	code

	end
