	page	,132
	title	varstck - Stub for varstck heap routine
;***
;varstck.asm - Stub for varstck heap routine
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This stub module calls the varstck version of near malloc.
;	If this object is explicitly linked into the user's program,
;	that program will get the 'stack robbing' version of _nmalloc
;	instead of the 'normal' version.
;
;*******************************************************************************


include version.inc
.xlist
include cmacros.inc
.list

	public	__nmalloc	; this module
	public	__nfree 	; this module

	extrn	___nmalloc:near ; actual varstck nmalloc
	extrn	___nfree:near	; actual varstck nfree

sBegin	code

	assumes cs,code
;***
;_nmalloc,_nfree - allocate/free near memory via __nmalloc/__nfree
;
;Purpose:
;	Routine directly transfers to __nmalloc/__nfree
;	(defined in nmalloc.asm).
;
;Entry:
;	See __nmalloc.
;
;Exit:
;	See __nmalloc.
;
;Uses:
;	See __nmalloc.
;
;Exceptions:
;	See __nmalloc.
;
;*******************************************************************************

__nmalloc:
	jmp	___nmalloc	; jump to library routine to do real work

__nfree:
	jmp	___nfree	; jump to library routine to do real work

sEnd	code

	end
