	page	,132
	title	walklist -- Walk a linked heap list
;***
;walklist.asm - Walk a linked heap list
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

externNP _listchk			; validate a heap list
externNP _walkone			; report on a heap entry
externNP _findseg			; find a heap segment

sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;_walklist - Walk a linked heap list
;
;Purpose:
;	Get the next heap entry (along with size and used/free
;	status).  If _heapinfo._pentry == NULL, return information
;	about the first entry in the heap.
;
;Entry:
;	ds:bx = address of heap list header
;
;	es:di = &_heapinfo = address of a _heapinfo structure
;		(possibly returned by a previous call to _walklist).
;		The contents are:
;
;		_pentry = far pointer to heap entry (could be NULL)
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Exit:
;	ax = Return value is one of the following constants:
;
;	_HEAPEMPTY	- far heap not initialized
;	_HEAPBADBEGIN	- can't find initial header info
;	_HEAPBADNODE	- malformed node somewhere
;	_HEAPOK 	- heap ok
;	_HEAPEND	- end of heap reached
;
;	Fills in the _heapinfo structure as follows:
;
;		_pentry = far pointer to heap entry
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Uses:
;	bx, cx, dx, si
;Preserves:
;	ds, es:di
;Exceptions:
;
;*******************************************************************************

cProc	_walklist,<PUBLIC,NEAR>,<>

cBegin	<nogen>

	push	ds			; save caller's ds
	push	bx			; save heap list offset

; Validate the heap list header (checks for empty heap, too)
; ds:bx = heap list header
; es:di = &heapinfo

	call	_listchk		; validate list header
	cmp	ax,_HEAPOK		; header ok ??
	jne	done			; nope, error or empty

; See if the the address we're passed is NULL or not
; ds:bx = far heap header
; es:di = &heapinfo

	mov	ax,es:[di]._pentry_seg	; ax = segment portion of pointer
	mov	si,es:[di]._pentry_off	; si = offset portion of pointer
	mov	cx,ax			; save segment for later
	or	cx,si			; is the pointer == null ??
	jz	null			; yes, jump out
	;fall thru			; no

	assumes ds,nothing

;
; Heap entry pointer is NOT null
;
; ds:bx = heap linked list header
; es:di = heapinfo structure
; ax:si = _pentry address
;

non_null:
	call	_findseg		; go find the heap descriptor
	jc	badptr			; error - couldn't find desc

	; ds:bx = heap descriptor
	; ds:si = _pentry address

	mov	ax,[si-2]		; ax = header of current entry
	and	al,not 1		; mask off used/free bit
	add	si,ax			; si = pointer to next header
	jnc	heap_entry		; report on this entry
	;fall thru			; error - bad pointer

;
;------ Error returns ------
;

badptr:
	mov	ax,_HEAPBADPTR		; bad heap pointer
	jmp	short done		; join common return

;
;------ End Errors ---------
;

;
; Heap entry pointer is null; use the first entry in the first segment.
; ds:bx = far heap descriptor
;

null:
	lds	bx,[bx].startseg	; ds:bx = first far heap segment
	jmp	short first_entry	; report on the first entry in the seg

;
; Reached the end of a heap segment, onto the next one
; ds:bx = heap segment descriptor
; es:di = &_heapinfo
; ax = _HEAPEND
;

next_seg:
	mov	dx,ds			; save ds:bx for last seg check
	mov	cx,bx
	lds	bx,[bx].nextseg 	; yes, get next segment entry
	mov	si,ds			; is pointer == NULL ??
	or	si,bx
	jne	first_entry		; no, onto the next segment

	; reached last segment -- validate it
	; dx:cx = last segment
	pop	bx
	pop	ds			   ; ds:bx = list header
	cmp	cx,word ptr [bx].lastseg   ; lastseg offsets match ??
	jne	badbegin		   ; nope, error
	cmp	dx,word ptr [bx].lastseg+2 ; lastsegs segments match ??
	je	short done0		   ; yes, return _HEAPEND
badbegin:
	mov	ax,_HEAPBADBEGIN	; error, return _HEAPBADBEGIN
	jmp	short done0


first_entry:
	mov	si,[bx].start		; get first entry in this segment
	;fall thru			; report on this entry

;
; Report on the current heap entry
; ds:bx = heap descriptor
; ds:si = memory block to report on
; es:di = &_heapinfo
;

heap_entry:
	call	_walkone		; report on this entry
	cmp	ax,_HEAPEND		; end of this heap segment ??
	je	next_seg		; yes, continue
	;fall thru			; nope, return ax

;
; Common return
; ax = return value
;

done:
	pop	bx			; clear off heap list offset
	pop	ds			; restore caller's ds
done0:
	ret

cEnd	<nogen>

sEnd	code

	end
