	page	,132
	title	walkone -- Report on a heap entry
;***
;walkone.asm - Report on a heap entry
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Walkone() reports on a single heap entry.  It is for use with
;	the heapwalk routines.
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list


; Make sure assumptions about values are correct
.ERRE	_FREEENTRY	EQ	0

externNP _headchk			; validate heap segment

sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;_walkone - Report on a heap entry
;
;Purpose:
;	Walkone() reports on a single heap entry.  It is for use with
;	the heapwalk routines.
;
;Entry:
;	ds:bx = heap segment descriptor
;	ds:si = heap entry to report on
;	es:di = &_heapinfo = address of a _heapinfo structure
;		(possibly returned by a previous call to _walkone).
;		The contents are:
;
;		_pentry = far pointer to heap entry (could be NULL)
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Exit:
;	ax = Return value is one of the following constants:
;
;	_HEAPEMPTY	- far heap not initialized
;	_HEAPBADBEGIN	- can't find initial header info
;	_HEAPBADNODE	- malformed node somewhere
;	_HEAPOK 	- heap ok
;	_HEAPEND	- end of heap reached
;
;	Fills in the _heapinfo structure as follows:
;
;		_pentry = far pointer to heap entry
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Uses:
;	si, cx, dx
;Preserves:
;	ds:bx, es:di
;Exceptions:
;
;*******************************************************************************

cProc	_walkone,<PUBLIC,NEAR>,<>

cBegin	<nogen>

;
; NOTE: The following two pointers do not change throughout
; this routine:
;
;	 ds:bx = heap descriptor
;	 es:di = &_heapinfo struct
;

;
; Make sure the heap descriptor header is ok
; ds:si = memory block to report on
;

	push	es			; save es,si,di
	push	di
	push	si
	call	_headchk		; validate the segment
	pop	si			; restore es,di,di
	pop	di
	pop	es
	cmp	ax,_HEAPOK		; heap segment ok ??
	jne	done			; nope, return ax value

;
; Make sure the offset is not too big
;

	mov	dx,[bx].segsize 	; dx = segment size
	dec	dx			; in case size == 0
	cmp	si,dx			; new offset > segment size ??
	ja	badptr			; yes, error - bad pointer

;
; Get size and determine if at end of heap
;

	cld				; forward scan
	lodsw				; ax = header of entry
	cmp	ax,_HEAP_END		; are we at the end of the heap ??
	je	heapend 		; yes, end of heap segment

;
; Ok, report on the current block
; ds:bx = heap descriptor
; ds:si = memory block to report on
; es:di = &_heapinfo struct
; dx = segment size - 1
;

	mov	cx,_USEDENTRY		; assume block is not free
	test	al,1			; is it free ??
	jz	store			; no, jump down
	xor	cx,cx			; yes, cx = _FREEENTRY
	dec	ax			; ax = size

store:					; update the user's _heapinfo block
	mov	es:[di]._size,ax	; store the size of the block
	mov	es:[di]._useflag,cx	; store the free/used flag
	mov	es:[di]._pentry_seg,ds	; segment = ds
	mov	es:[di]._pentry_off,si	; save current offset

	add	si,ax			; get next header
	jc	badnode 		; error - bad node
	cmp	si,dx			; new pointer > size of segment ??
	jbe	heapok			; nope, take good return
	;jmp	short badnoe		; yes, error - bad node

;
;------ Error returns ------
;

badnode:
	mov	ax,_HEAPBADNODE 	; bad heap node
	jmp	short done		; join common return

badptr:
	mov	ax,_HEAPBADPTR		; bad heap pointer
	jmp	short done		; join common return

;
; --- End of heap
; si = pointer to _HEAP_END + 2
;

heapend:
	dec	si
	dec	si			; si = addr _HEAP_END
	cmp	si,[bx].last		; did we find the "real" end ??
	jne	badnode 		; nope, return an error

	mov	ax,_HEAPEND		; end of heap
	jmp	short done		; join common return

;
; --- Heap is ok ---
;

heapok:

	mov	ax,_HEAPOK		; heap is ok so far
	;jmp	 short done		 ; join common return

;
; Common return
; ax = return value
;

done:
	ret

cEnd	<nogen>

sEnd	code

	end
