	page	,132
	title	walkseg -- Walk a single heap segment
;***
;walkseg.asm - Walk a single heap segment
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;
;*******************************************************************************

include	version.inc
.xlist
include	cmacros.inc
include heap.inc
.list

externNP _walkone			; report on a heap entry

sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
;_walkseg - Walk the near heap
;
;Purpose:
;	Get the next heap entry (along with size and used/free
;	status).  If _heapinfo._pentry == NULL, return information
;	about the first entry in the heap.
;
;Entry:
;	ds:bx = heap descriptor
;
;	es:di = &_heapinfo = address of a _heapinfo structure
;		(possibly returned by a previous call to _walkseg).
;		The contents are:
;
;		_pentry = far pointer to heap entry (could be NULL)
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;Exit:
;	ax = Return value is one of the following constants:
;
;	_HEAPEMPTY	- near heap not initialized
;	_HEAPBADBEGIN	- can't find initial header info
;	_HEAPBADNODE	- malformed node somewhere
;	_HEAPOK 	- heap ok
;	_HEAPEND	- end of heap reached
;
;	Fills in the _heapinfo structure as follows:
;
;		_pentry = far pointer to heap entry
;		_size = size of entry
;		_useflag = indicates if entry is free or in use
;
;
;Uses:
;	cx, dx, si
;Preserves:
;	ds:bx, es:di
;Exceptions:
;
;*******************************************************************************

cProc	_walkseg,<PUBLIC,NEAR>,<>

cBegin	<nogen>

; *** NOTE: LARGE MODEL HAS NOT BEEN TESTED YET ***

;
; NOTE: The following two pointers do not change throughout
; this routine:
;
;	 ds:bx = heap descriptor
;	 es:di = &_heapinfo struct
;

;
; See if the the address we're passed is NULL or not
;

	mov	ax,es:[di]._pentry_seg	; ax = segment portion of pointer
	mov	si,es:[di]._pentry_off	; si = offset portion of pointer
	mov	cx,ax			; save segment for later
	or	ax,si			; is the pointer == null ??
	jz	null			; yes, jump down
	;fall thru			; no, pointer supplied

;
; Heap entry pointer is NOT null
;     (1) validate the pointer
;     (2) set up for reading the next entry
; cx:si = _pentry address
;

non_null:
	;validate segment value
	mov	ax,ds			; ax = heap desc segment
	cmp	cx,ax			; _pentry_seg == heap desc segment ??
	jne	badptr			; no, error - bad pointer

	;range check on offset value
	mov	ax,[bx].segsize 	; ax = segment size
	dec	ax			; dec in case it's 0
	cmp	si,ax			; offset > segment size ??
	ja	badptr			; nope, too big - error
	cmp	si,2			; offset >= 2 ??
	jb	badptr			; nope, too small - error

	;get next entry
	mov	ax,[si-2]		; ax = header of current entry
	and	al,not 1		; mask off used/free bit
	add	si,ax			; si = pointer to next header
	jnc	heap_entry		; report on this entry
	;jmp	short badptr		; error - bad pointer

;
; --- Error returns ---
;

badptr:
	mov	ax,_HEAPBADPTR		; bad heap pointer
	jmp	short done		; join common return

;
; --- End errors ---
;

;
; Heap entry pointer is null; report on the first entry
;

null:
	mov	si,[bx].start		; si = start of heap
	;fall thru			; report on this entry

;
; Report on this entry.
; ds:bx = heap segment descriptor
; ds:si = _pentry address
; es:di = _heapinfo address
;

heap_entry:
	call	_walkone		; report on this entry
	;fall thru			; return ax

;
; Common return
; ax = return value
;

done:
	ret

cEnd	<nogen>

sEnd	code

	end
