	page	,132
	title	halloc - C Run-time huge heap allocation
;***
;halloc.asm - OS/2 huge heap allocation
;
;	Copyright (c) 1986-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines halloc() and hfree() - huge array allocation, deallocation
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include msdos.inc
ifdef _WINDOWS
include heap.inc
include rterr.inc
endif
.list

assumes CS,CODE
assumes DS,DATA

	page
ifndef _WINDOWS
;
;	OS/2 Function Calls
;
	extrn	DOSFREESEG:far	; deallocate a segment
	extrn	DOSALLOCHUGE:far; allocate a huge segment
else
;
;	Windows Function Calls
;
	extrn	__amsg_exit:near	; write error and die

	extrn	__whclear:near	; clear a segment/handle entry
	extrn	__whset:near	; set a segment/handle entry

	extrn	GLOBALALLOC:far ; allocate memory from global heap
	extrn	GLOBALFREE:far	; deallocat memory from global heap
	extrn	GLOBALLOCK:far	; lock down new segment
	extrn	GLOBALUNLOCK:far; lock down new segment
endif

	extrn	__AHSHIFT:abs	; "huge" shift count

ifndef	_NOTCXX_
sBegin	DATA
globalCP  _pnhhHugeHeap, 0
sEnd	DATA
endif	;not _NOTCXX_

sBegin	CODE

ifdef _WINDOWS
	extrn	__wflags:word		; Windows status flags
endif

ifndef	_NOTCXX_
endif

page
;***
;int _hfree(address) - deallocates huge segment array
;
;Purpose:
;	Deallocates a huge array allocated through halloc(), the memory
;	is returned to DOS.
;
ifdef _WINDOWS
;	[See notes under _halloc.]
endif
;
;Entry:
;	huge *address - ptr to memory block to be freed
;
;Exit:
;	any error status in AX
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_hfree,<PUBLIC>
	parmD	address
cBegin

ifndef _WINDOWS

	push	word ptr (address+2)	; ignore offset portion of pointer
	call	DOSFREESEG

else	;_WINDOWS

	push	word ptr (address+2)	; push segment portion of ptr

	; unlock block, if protect mode
	test	[__wflags],WF_PMODE	; Are we in protect mode ??
	jz	@F			; jump if not

					; segment already on stack
	call	__whclear		; clear segment entry
	add	sp,2
	or	ax,ax			; ax = handle, 0 = error
	jz	hfree_done		; assume user error

	push	ax			; push handle, for GLOBALUNLOCK
	push	ax			; push handle, for GLOBALFREE
	call	GLOBALUNLOCK		; unlock the segment
@@:
	call	GLOBALFREE		; selector portion is the handle

hfree_done:

endif	;_WINDOWS

cEnd


page
;***
;HUGE *_halloc(cnumber, cbsize) - allocate huge segment array
;
;Purpose:
;	Allocate a huge array from DOS.  If the array is greater than
;	128KB is size, the array elements must be a power of 2 in size.
;	NOTE: this code allocates the exact number of bytes requested!
;
ifdef _WINDOWS
;	Notes:
;	(1) In protect mode, we must keep track of the handle associated
;	with the segment we return to the user.  Call the _wh*() routines
;	to do this.
;	(2) If allocating less than 64K, we must get a multiple of
;	4K to ensure that the offset we get back is 0.
endif
;
;Entry:
;	long cnumber - number of elements in array
;	int size - number of bytes per element
;
;Exit:
;	DS:AX - address of array start.
;	if error, DS:AX is 0:0
;
;Uses:
;	AX, BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_halloc,<PUBLIC>,<si,di>
	parmD	cnumber 	; Number of objects
	parmW	cbsize		; Size of objects in bytes
	localW	selector	; Selector of beginning of allocation
cBegin
ifndef	_NOTCXX_
RetryHalloc:
endif
	mov	bx,cbsize
	mov	ax,word ptr (cnumber)
	mul	bx
	mov	cx,ax		; low word of allocation size
	mov	di,dx		; partial high word of ...

	mov	ax,word ptr (cnumber+2)
	mul	bx
	add	ax,di		; high word of allocation size
	mov	dx,ax

	or	ax,cx		; test for 0-length allocation
	jz	ret_zero

	xor	si,si		; offset to be returned
;
; In general, to clear the least significant `1' bit in a number "x",
; do a bit-wise AND of "x" with "x"-1.	To check if "x" is a power of 2,
; do this bit-wise AND of "x" and "x"-1, and check for a zero result,
; since a power of 2 has only a single `1' bit.  This trick is used in
; two places in the following code, and in both places it is known that
; "x" is non-zero.  (The trick presumes that "x" is non-zero.)
;
	lea	ax,[bx-1]	; AX = cbsize - 1
;
;	DX:CX is the allocation size
;	BX is "cbsize"
;	AX is "cbsize"-1
;	DI is scratch
;	SI is the offset to be returned (usually 0)
;
not_zero:
	cmp	dx,2
	ja	more_than_128K	; Size is > 128 KB
	jb	less_equal_128K ; Size is < 128 Kbytes

	jcxz	less_equal_128K ; Size is = 128 Kbytes
;
; If the HUGE allocation is greater than 128 Kbytes,
; the array element size must be a power of two.
; "cbsize" must one of [1,2,4,8,...,16384,32768]
;
more_than_128K:
	and	ax,bx		; is "cbsize" a power of 2?
	jnz	ret_zero	; see above for explanation of this trick
	jmp	short alloc_memory
;
; For allocations between 64K+1 and 128K (inclusive),
; the last item in the first segment must end on the
; segment boundary.  This is done by starting the
; first element at offset (65536L % cbsize).
; If "cbsize" is a power of 2, the offset will be 0.
;
less_equal_128K:
	cmp	dx,1			; < 64K ??
ifdef _WINDOWS
	jae	more_than_64K		; if >= 64K, continue
	add	cx,(_HEAP_GROWSEG-1)	; round up to 4K boundary
	and	cx,not (_HEAP_GROWSEG-1); cx = new size (rounded up to 4K)
	or	cx,cx			; cx == 0 ??
	jnz	alloc_memory		; nope, get the memory
	inc	dx			; yes, dx:cx = 1:0
	jmp	short alloc_memory

	.ERRE	_HEAP_GROWSEG EQ 01000h ; make sure this is 4K

more_than_64K:
	; fall thru

else
	jb	alloc_memory
endif

	and	ax,bx		; is "cbsize" a power of 2?
	jz	alloc_memory	; see above for explanation of this trick

	xor	ax,ax		; no, DX:AX = 1:0 = 65536L
	div	bx		; dx = (65536 % cbsize)
	mov	si,dx		; save return offset
	add	cx,dx		; bump size of request by remainder
	jc	ret_zero	; addition caused request to be > 128k and
				;    cbsize is not a power of two...
	mov	dx,1		; restore dx to original value
;
; Allocate the huge block
;
alloc_memory:
	push	dx		; preserve over call site
	push	cx		;

ifndef _WINDOWS

	push	dx		; number of full 64KB segments
	push	cx		; number of bytes in final segment
	lea	ax,selector
	push	ss
	push	ax		; address in which to store selector
	xor	ax,ax
	push	ax		; maximum number of 64K segments (0)
	push	ax		; sharing flags (0)
	call	DOSALLOCHUGE
	pop 	cx		; restore registers after call site
	pop 	dx		;
	test	ax,ax
	jnz	ret_zero	; failed to allocate

	mov	ax,[selector]	; [selector]:SI = starting address

else	;_WINDOWS

	mov	bx,[__wflags]	; bx = flags word

	; allocate memory
	mov	ax,_HEAP_PROTECT; assume protect mode
	test	bx,WF_PMODE	; protect mode ??
	jnz	@F		; jump if so
	mov	ax,_HEAP_REAL	; no, real mode
@@:
	push	bx		; save __wflags around call
	push	ax		; alloc flags
	push	dx		; number of full 64KB segments (high word of long)
	push	cx		; number of bytes in final segment (low word)
	call	GLOBALALLOC ; returns 0 for failure, handle is return
				; ax = new selector or 0
	pop	bx		; bx = __wflags
	or	ax,ax		; error ??
	jz	win_ret 	; is so, join return code
	test	bx,WF_PMODE	; protect mode ?
	jz	win_ret 	; if not, join return code

	;
	; lock memory, if protect mode
	; [In protect mode, this call can never fail if
	; GLOBALALLOC succeeds.]
	;

	push	ax		; save handle on stack for later
	push	ax		; do it again...

	push	ax		; push handle
	call	GLOBALLOCK	; lock down segment
	or	ax,ax		; make sure offset == 0
	jnz	fatal_err	; bogus
	or	ax,dx		; make sure segment is not 0
	jz	fatal_err	; bogus
	mov	ax,dx		; ax = new selector

				; handle is already on stack
	push	ax		; push selector
	call	__whset 	; put segment/handle in table
	add	sp,4		; ax = new segment or 0 for error
	pop	cx		; cx = handle
	or	ax,ax		; was seg/hand enterred in table ??
	jnz	win_ret 	; yup, everything's cool
				; no, free up memory
	push	cx		; push handle for GLOBALUNLOCK
	push	cx		; push handle for GLOBALFREE
	call	GLOBALUNLOCK
	call	GLOBALFREE
	xor	ax,ax		; 0 = error
win_ret:
	pop 	cx		; restore registers after call site
	pop 	dx		;
	or	ax,ax		; error ??
	jz	ret_zero	; failed to allocate

	mov	[selector],ax	; [selector]:SI = starting address

endif	;_WINDOWS

	cld			; Must be in UP direction
	xor	di,di
	mov	bx,cx
;
; Allocated memory must be initialized to zero, 64KB at a time
;
; [selector]:SI = return value
; ES/AX = next segment
;	NOTE:	Only valid selectors may be placed in ES.
;		ES is loaded on a "lazy" basis, that is,
;		only just before it is going to be used.
; DI and CX are used by the REP STOSW instruction
; DX = count of full 64 KB segments
; BX = count of bytes in final segment
;
	test	dx,dx
	jz	zero_rest
zero64K:
	mov	es,ax		; store only valid selectors in ES
	xor	ax,ax
	mov	cx,8000H	; zero out a 64K segment
	rep	stosw
	inc	ax		; AX = 1
	mov	cx,__AHSHIFT
	shl	ax,cl		; AX = HUGE increment
	mov	cx,es
	add	ax,cx		; AX is next segment
	dec	dx
	jne	zero64K
;
;	Zero out the final segment, which is less than 64KB long
;	DI is still zero after the loop above
;
zero_rest:
	mov	cx,bx
	jcxz	none_rest	; no bytes in final segment?

	mov	es,ax		; ES points to final segment
	xor	ax,ax
	rep	stosb

none_rest:
	mov	dx,[selector]
	xchg	ax,si		; DX:AX = return value
	jmp	short ret_okay
;
;	Set DX:AX = 0L, indicating an error
;
ret_zero:

	xor	ax,ax
	cwd

ifndef	_NOTCXX_
if  sizeC
	mov	cx, word ptr (_pnhhHugeHeap+2)
	or	cx, word ptr (_pnhhHugeHeap)
	jz	ret_okay
else	;not sizeC
	cmp	(_pnhhHugeHeap), ax	; ax = 0.
	je	ret_okay
endif	;not sizeC

	push	word ptr [cnumber+2]
	push	word ptr [cnumber]
	push	[cbsize]
	call	(_pnhhHugeHeap)
	add	sp, 6
	cwd			; Set dx:ax = NULL, if ax = 0.
	or	ax, ax
	jz	ret_okay	; if ax = 0, then return NULL.

	jmp	RetryHalloc
endif	;not _NOTCXX_

;
;	DX:AX = return value
;
ret_okay:

cEnd

ifdef _WINDOWS
;
; --- Fatal error ---
;

fatal_err:
	mov	ax,_RT_HEAP		; Unexpected heap error
	jmp	__amsg_exit		; fatal error handler

endif

sEnd	CODE

	end
