/***
*nheap2.c - Windows near heap routines (part 2)
*
*   Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Provides heap routine interfaces for windows/C libs.
*   Contains the "non-essential" routines.
*
*   NOTE:  Currently, the C runtime libs assume that the DGROUP
*   selector will NEVER change value.  To ensure this, lock down
*   DGROUP whenever issueing a local allocation call.
*
*******************************************************************************/

#include <windows.h>
#include <malloc.h>
#include <sizeptr.h>
#include <stddef.h>

/*---------------------------------------------------------------------------*/
/*                                       */
/*  _nexpand()                                   */
/*                                       */
/*---------------------------------------------------------------------------*/

void _near * _nexpand(p, n)
void _near *  p;
size_t  n;

{
  HANDLE    h;

  LockData(0);

  h = ((HANDLE)LocalReAlloc((HANDLE)p, (n ? n : 1),
            LMEM_NODISCARD | LMEM_ZEROINIT));

  UnlockData(0);

  return((void _near *)h);
}

/*---------------------------------------------------------------------------*/
/*                                       */
/*  _memavl()                                    */
/*                                       */
/*---------------------------------------------------------------------------*/

size_t _memavl(void)

{
  size_t s;

  LockData(0);

  s = ((size_t)LocalCompact(0));

  UnlockData(0);

  return(s);
}

/*---------------------------------------------------------------------------*/
/*                                       */
/*  _memmax()                                    */
/*                                       */
/*---------------------------------------------------------------------------*/

size_t _memmax(void)

{
  size_t s;

  LockData(0);

  s = ((size_t)LocalCompact(0));

  UnlockData(0);

  return(s);
}


/*---------------------------------------------------------------------------*/
/*                                       */
/*  _freect()                                    */
/*                                       */
/*---------------------------------------------------------------------------*/

unsigned int _freect(n)
size_t  n;

{
  unsigned int f;

  LockData(0);

  f = ((WORD) (LocalCompact(0) / (n ? n : 1)));

  UnlockData(0);

  return(f);
}
