	page	,132
	title	xheap - Xenix heap initialization
;***
;xheap.asm - Xenix heap initialization
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	(1) Init the near heap
;	(2) Contains heap data
;
;*******************************************************************************

?DF	=	1		; tell cmacros.inc we want to define our own segments

include	version.inc
.xlist
include	cmacros.inc
include defsegs.inc
include heap.inc
.list

CrtDefSegs  <code,data>
CrtDefSegs  <xiseg>

;--- Put the near heap init routine in the initializer table ---

sBegin	xiseg

if	sizeC
	dd	_xheapinit
else
	dw	_xheapinit
endif

sEnd


;--- Near heap descriptor ---

sBegin	data
	assumes ds,data

labelW	<PUBLIC,_nheap_desc>	; near heap descriptor
_heap_seg_desc <0,_HEAP_NEAR OR _HEAP_MODIFY, 0,0,0,0,0,0>
.ERRE	flags	eq	2	; flags better be second word

sEnd	data


externP brkctl			; system call for memory
externP abort			; abort on error

sBegin	code
	assumes ds,data
	assumes cs,code

page
;***
; _xheapinit - Init the xenix near heap
;
;Purpose:
;	This routine initializes the near heap at startup time.
;
;	NOTE: Since this routine is called as an initializer,
;	we have to preserve <si>.
;Entry:
;	ds = DGROUP (assumed for brkctl call)
;
;Exit:
;
;Uses:
;	ax, bx, dx
;Exceptions:
;
;*******************************************************************************

cProc	_xheapinit,<PUBLIC>,<si>

cBegin

;
; See how big DGROUP is and then make room for the near heap
;
	xor	dx,dx		; dx = 0
	push	ds
	push	dx		; ds:0 = segment pointer
	push	dx
	push	dx		; length = 0
	mov	ax,BR_ARGSEG	; increment existing segment
	push	ax		; ax = BR_ARGSEG
	call	brkctl		; brkctl(BR_ARGSEG,0L,DS:0)
	cmp	dx,-1		; dx:ax == -1 ??
	jne	ok		; nope, continue
	;fall thru		; yes, error

;
;--- Error ---
;

error1:
	add	sp,0Ah		; clean off brkctl args
error2:
	call	abort		; --- FATAL ERROR ---
	;should never get here

;
; Make room in DGROUP for near heap.  Make sure the near heap
; is aligned on an even byte boundary.
; ax = length of DGROUP (in bytes)
; stack = still contains brkctl args

ok:
	and	ax,1		; ax = 1 or 0
	add	ax,4		; ax = 4 or 5
	mov	bx,sp		; sp into index register
	mov	[bx+2],ax	; change length arg on stack
	call	brkctl		; brkctl(BR_ARGSEG,<ax>L,DS:0)
	add	sp,0Ah		; toss args
	cmp	dx,-1		; dx:ax == -1 ??
	je	error2		; yes, error...
	;fall thru		; nope, continue

;
; Convert the newly aquired memory into a near heap.
; dx:ax = pointer to new chunk of DGROUP
;

	mov	bx,dataoffset _nheap_desc ; ds:bx = near heap descriptor
	mov	[bx].checksum,ds; save DS in heap descriptor

	inc	ax
	and	ax,not 1	; make sure pointer is even
	mov	[bx].start,ax	; init start/rover
	mov	[bx].rover,ax
	mov	si,ax		; si = base of heap
	mov	word ptr [si],1	; create 0 length free heap entry
	add	si,2		; point at end of heap
	mov	[bx].last,si	; init last pointer
	mov	word ptr [si],_HEAP_END ; set end of heap marker
	add	si,2		; si = past end of heap
	mov	[bx].segsize,si ; init segment size

cEnd	<nolocals>

sEnd	code

	end
