	page	,132
	title	aldiv - assigning signed long divide
;***
;aldiv.asm - Assigning Signed Long Divide routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines assigning signed long divide routines
;	creates the following routines:
;	    __aFFaldiv	(large model)
;	    __aFNaldiv	(medium model)
;	    __aNFaldiv	(compact model)
;	    __aNNaldiv	(small model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;aldiv - assigning signed long divide
;
;Purpose:
;	does a signed long divide, assigning the result to the dividend.
;	calls ldiv to do all the real work
;
;Entry:
;	parameters passed on stack as follows:
;		1st pushed: divisor (DWORD)
;		2nd pushed: address of dividend
;			    (DWORD in models C,L; WORD in models S,M)
;
;Exit:
;	dividend is updated to (dividend/divisor)
;	NOTE: parameters are removed from stack by this routine
;
;Uses:
;	AX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

aASGN	ldiv

; Set up the local stack and save the index registers.	When this is done
; the stack frame will look as follows (assuming that the expression a/=b will
; generate a call to aldiv(&a, b)):
;
;	  -----------------
;	  |		  |
;	  |---------------|
;	  |		  |
;	  |--divisor (b)--|
;	  |		  |
;	  |---------------|
;	  |address of a***|
;	  |---------------|
;	  | return addr** |
;	  |---------------|
; BP,SP-->|   old BP	  |
;	  |---------------|
;	  |		  |
;	  -----------------
;
; ** - 2 bytes if small/compact model; 4 bytes if medium/large model
; *** - 2 bytes if small/medium model; 4 bytes if compact/large model

PNTR	equ	(BPARGBAS)[bp]	; stack addr. of data pointer
DIVSR	equ	BPARGBAS+DAT_ADDR_SZ[bp] ; stack address of divisor
DIVND	equ	[bx]		; address of dividend

if	sizeD
	push	ds
endif
	push	bx

; We will use the regular ldiv routine to do all the work.  We simply set up
; the arguments properly, call ldiv to do the work, and store the result.

	LOAD	bx,PNTR 	; load the pointer to a into bx or ds:bx
	push	2+DIVSR 	; push the divisor
	push	DIVSR
	push	2+DIVND 	; push dividend
	push	DIVND

	callnahlpr ldiv 	; call __a?ldiv to do the actual work

	mov	HIWORD(DIVND),dx ; store result
	mov	LOWORD(DIVND),ax

; Clean up the stack and return.

	pop	bx
if	sizeD
	pop	ds
endif

cEnd	nolocals
return	4+DAT_ADDR_SZ

sEnd

	end
