	page	,132
	title	almul - assigning long multiply
;***
;almul.asm - Assigning Long Multiply routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines assigning long multiply routines
;	Unsigned multiply is the same as signed multiply, due to
;	2's complement arithmetic.
;	creates the following routines:
;	 __aFFalmul,__aFFaulmul (large model)
;	 __aFNalmul,__aFNaulmul (medium model)
;	 __aNFalmul,__aNFaulmul (compact model)
;	 __aNNalmul,__aNNaulmul (small model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;almul - assigning long multiply
;
;Purpose:
;	does a long multiply, assigning the result to the multiplicand.
;	calls lmul to do all the real work
;
;Entry:
;	parameters passed on stack as follows:
;		1st pushed: multiplier (DWORD)
;		2nd pushed: address of multiplicand
;			    (DWORD in models C,L; WORD in models S,M)
;
;Exit:
;	multiplicand is updated with product
;	NOTE: parameters are removed from stack by this routine
;
;Uses:
;	AX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

;
;	Define entry points for "unsigned" multiply as well as for "signed" LMUL
;

if	memL
	PUBLIC	__aFFaulmul
__aFFaulmul:
endif

if	memM
	PUBLIC	__aFNaulmul
__aFNaulmul:
endif

if	memC
	PUBLIC	__aNFaulmul
__aNFaulmul:
endif

if	memS
	PUBLIC	__aNNaulmul
__aNNaulmul:
endif
aASGN	lmul

; Set up the local stack and save the index registers.	When this is done
; the stack frame will look as follows (assuming that a*=b will
; generate a call to almul(&a, b)):
;
;	 -----------------
;	 |		 |
;	 |---------------|
;	 |		 |
;	 |-----  b  -----|
;	 |		 |
;	 |---------------|
;	 |address of a***|
;	 |---------------|
;	 | return addr** |
;	 |---------------|
;BP,SP-->|    old BP	 |
;	 |---------------|
;	 |		 |
;	 -----------------
;
; ** - 2 bytes if small/compact model; 4 bytes if medium/large model
; *** - 2 bytes if small/medium model; 4 bytes if compact/large model

PNTR	equ	BPARGBAS[bp]	; stack address of data pointer
BB	equ	BPARGBAS+DAT_ADDR_SZ[bp] ; stack address of b
AA	equ	[bx]		; address of a

if	sizeD
	push	ds
endif
	push	bx

; We will simply call lmul to do the actual work.  As a result, all we have
; to do here is load the parameters and store the result.

	LOAD	bx,PNTR 	; load the pointer to a into bx or ds:bx
	push	2+BB		; push b
	push	BB
	push	2+AA		; push a
	push	AA

	callnahlpr lmul 	; call __a?lmul to do the actual multiply
	mov	LOWORD(AA),ax	; store the result
	mov	HIWORD(AA),dx

	pop	bx
if	sizeD
	pop	ds
endif

cEnd	nolocals
	return	4+DAT_ADDR_SZ

sEnd

	end
