	page	,132
	title	alrem - assigning signed long remainder
;***
;alrem.asm - Assigning Signed Long Remainder routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines assigning signed long remainder routines
;	creates the following routines:
;	    __aFFalrem	(large model)
;	    __aFNalrem	(medium model)
;	    __aNFalrem	(compact model)
;	    __aNNalrem	(small model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;alrem - assigning signed long remainder
;
;Purpose:
;	does a signed long remainder, assigning the result to the dividend.
;	calls lrem to do all the real work
;
;Entry:
;	parameters passed on stack as follows:
;		1st pushed: divisor (DWORD)
;		2nd pushed: address of dividend
;			    (DWORD in models C,L; WORD in models S,M)
;
;Exit:
;	dividend is updated
;	NOTE: parameters are removed from stack by this routine
;
;Uses:
;	AX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

aASGN	lrem

; Set up the local stack and save the index registers.	When this is done
; the stack frame will look as follows (assuming that the expression a%=b will
; generate a call to alrem(&a, b)):
;
;	 -----------------
;	 |		 |
;	 |---------------|
;	 |		 |
;	 |--divisor (b)--|
;	 |		 |
;	 |---------------|
;	 |address of a***|
;	 |---------------|
;	 | return addr** |
;	 |---------------|
;BP,SP-->|    old BP	 |
;	 |---------------|
;	 |		 |
;	 -----------------
;
; ** - 2 bytes if small/compact model; 4 bytes if medium/large model
; *** - 2 bytes if small/medium model; 4 bytes if compact/large model

PNTR	equ	BPARGBAS[bp]	; stack addr. of data pointer
DIVSR	equ	BPARGBAS+DAT_ADDR_SZ[bp] ; stack address of divisor
DIVND	equ	[bx]		; address of dividend

if	sizeD
	push	ds
endif
	push	bx

; We will use the regular lrem routine to do all the work.  We simply set up
; the arguments properly, call lrem to do the work, and store the result.

	LOAD	bx,PNTR 	; load the pointer to a into bx or ds:bx
	push	2+DIVSR 	; push the divisor
	push	DIVSR
	push	2+DIVND 	; push dividend
	push	DIVND

	callnahlpr lrem 	; call __a?lrem to do the actual work
	mov	HIWORD(DIVND),dx ; store result
	mov	LOWORD(DIVND),ax

	pop	bx
if	sizeD
	pop	ds
endif

cEnd	nolocals
	return	4+DAT_ADDR_SZ	; callee restores the stack

sEnd
	end
