	page	,132
	title	alshr - assigning signed long shift right
;***
;alshr.asm - Assigning Signed Long Shift Right routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines assigning signed long shift right routines
;	creates the following routines:
;	    __aFFalshr	(large model)
;	    __aFNalshr	(medium model)
;	    __aNFalshr	(compact model)
;	    __aNNalshr	(small model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;alshr - assigning signed long shift right
;
;Purpose:
;	does a signed long shift right, assigning the result to the dividend.
;	calls lshr to do all the real work
;
;Entry:
;	parameters passed on stack as follows:
;		1st pushed: shift count (WORD)
;		2nd pushed: address of long to be shifted
;			    (DWORD in models C,L; WORD in models S,M)
;
;Exit:
;	the long is updated
;	NOTE: parameters are removed from stack by this routine
;
;Uses:
;	AX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

aASGN	lshr

; Move arguments into registers and invoke the regular shift routine to
; do the work.	The local stack looks as follows after it has been set up:
;
;	 -------------------------
;	 |			 |
;	 |-----------------------|
;	 |	shift count	 |
;	 |-----------------------|
;	 |pointer to long value**|
;	 |-----------------------|
;	 |    return address*	 |
;	 |-----------------------|
;BP,SP-->|	  old BP	 |
;	 |-----------------------|
;	 |			 |
;	 -------------------------
;
; * - 2 bytes if small/compact model; 4 bytes if medium/large model
; ** - 2 bytes if small/medium model; 4 bytes if large/compact model

PNTR	equ	BPARGBAS[bp]	; stack addr. of data pointer
SHFTCNT equ	DAT_ADDR_SZ+BPARGBAS[bp] ; stack addr. of shift count
VAL	equ	[bx]		; address of data value

if	sizeD
	push	ds
endif
	push	bx

	LOAD	bx,PNTR 	; get pointer to data into bx or ds:bx
	mov	ax,LOWORD(VAL)	; dx:ax <- long data value
	mov	dx,HIWORD(VAL)
	mov	cx,SHFTCNT	; cx <- shift count

	callnahlpr lshr 	; use __a?lshr to do the actual shifting

; store away shifted value and return

	mov	LOWORD(VAL),ax	; store shifted value
	mov	HIWORD(VAL),dx

	pop	bx
if	sizeD
	pop	ds
endif

cEnd	nolocals
return	2+DAT_ADDR_SZ

sEnd

	end
