	page	,132
	title	c51stubs - Defines stubs for C5.1 libraries.
;***
;c51stubs.asm - Defines stubs for C5.1 libraries.
;
;   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;   This file defines the stubs needed to use the C5.1 libs with the
;   C6.0 and QC 2.5 compilers.
;
;*******************************************************************************

?PLM=0
?WIN=0

.xlist
	include cmacros.inc
.list


MakeStubs  macro    name

public __aF&name
__aF&name&:

public __aN&name
__aN&name&:

extrn __&name&:near
	jmp	__&name

	endm


sBegin	code
assumes cs,code

ifdef _CHKSTK_
    MakeStubs	<chkstk>

elseifdef _FTOL_
    MakeStubs	<ftol>


elseifdef _FCOM_
    MakeStubs	<fcmp>
    MakeStubs	<fcompp>

elseifdef _CCALL_
    MakeStubs	<fadd>
    MakeStubs	<fmul>
    MakeStubs	<fsub>
    MakeStubs	<fsubr>
    MakeStubs	<fdiv>
    MakeStubs	<fdivr>
    MakeStubs	<fdup>
    MakeStubs	<fchs>

    MakeStubs	<fldd>
    MakeStubs	<fstdp>
    MakeStubs	<fstd>
    MakeStubs	<faddd>
    MakeStubs	<fmuld>
    MakeStubs	<fsubd>
    MakeStubs	<fsubdr>
    MakeStubs	<fdivd>
    MakeStubs	<fdivdr>

    MakeStubs	<fldw>
    MakeStubs	<fldl>
    MakeStubs	<fldq>


elseifdef _CCALLF_
    MakeStubs	<flds>
    MakeStubs	<fstsp>
    MakeStubs	<fsts>
    MakeStubs	<fadds>
    MakeStubs	<fmuls>
    MakeStubs	<fsubs>
    MakeStubs	<fsubsr>
    MakeStubs	<fdivs>
    MakeStubs	<fdivsr>
    MakeStubs	<dcvt>

elseifdef _CCALLS_
    MakeStubs	<elds>		 ; First make stubs for _e*
    MakeStubs	<estsp>
    MakeStubs	<ests>
    MakeStubs	<eadds>
    MakeStubs	<emuls>
    MakeStubs	<esubs>
    MakeStubs	<esubsr>
    MakeStubs	<edivs>
    MakeStubs	<edivsr>

    MakeStubs	<eldd>
    MakeStubs	<estdp>
    MakeStubs	<estd>
    MakeStubs	<eaddd>
    MakeStubs	<emuld>
    MakeStubs	<esubd>
    MakeStubs	<esubdr>
    MakeStubs	<edivd>
    MakeStubs	<edivdr>

    MakeStubs	<eldw>
    MakeStubs	<eldl>
    MakeStubs	<eldq>

    MakeStubs	<slds>		 ; Second make stubs for _s*
    MakeStubs	<sstsp>
    MakeStubs	<ssts>
    MakeStubs	<sadds>
    MakeStubs	<smuls>
    MakeStubs	<ssubs>
    MakeStubs	<ssubsr>
    MakeStubs	<sdivs>
    MakeStubs	<sdivsr>

    MakeStubs	<sldd>
    MakeStubs	<sstdp>
    MakeStubs	<sstd>
    MakeStubs	<saddd>
    MakeStubs	<smuld>
    MakeStubs	<ssubd>
    MakeStubs	<ssubdr>
    MakeStubs	<sdivd>
    MakeStubs	<sdivdr>

    MakeStubs	<sldw>
    MakeStubs	<sldl>
    MakeStubs	<sldq>


elseifdef _FCALL_
    MakeStubs	<fabs>
    MakeStubs	<fldz>
    MakeStubs	<ftst>
    MakeStubs	<fxch>
    MakeStubs	<fsttp>
    MakeStubs	<esttp>
    MakeStubs	<ssttp>
    MakeStubs	<fldt>
    MakeStubs	<eldt>
    MakeStubs	<sldt>


elseifdef  _CEIL_
    MakeStubs	<CIceil>

elseifdef  _SQRT_
    MakeStubs	<CIsqrt>

elseifdef  _TRAN_
    MakeStubs	<CIpow>
    MakeStubs	<CIlog>
    MakeStubs	<CIlog10>
    MakeStubs	<CIexp>

elseifdef  _TRIG_
    MakeStubs	<CIsin>
    MakeStubs	<CIcos>
    MakeStubs	<CItan>

elseifdef  _TRIGA_
    MakeStubs	<CIasin>
    MakeStubs	<CIacos>
    MakeStubs	<CIatan>
    MakeStubs	<CIatan2>

elseifdef  _TRIGH_
    MakeStubs	<CIsinh>
    MakeStubs	<CIcosh>
    MakeStubs	<CItanh>

elseifdef  _FLOOR_
    MakeStubs	<CIfloor>

elseifdef  _FMOD_
    MakeStubs	<CIfmod>

elseifdef  _FABS_
    MakeStubs	<CIfabs>

elseifdef  _CEILL_
    MakeStubs	<CIceill>

elseifdef  _SQRTL_
    MakeStubs	<CIsqrtl>

elseifdef  _TRANL_
    MakeStubs	<CIpowl>
    MakeStubs	<CIlogl>
    MakeStubs	<CIlog10l>
    MakeStubs	<CIexpl>

elseifdef  _TRIGL_
    MakeStubs	<CIsinl>
    MakeStubs	<CIcosl>
    MakeStubs	<CItanl>

elseifdef  _TRIGAL_
    MakeStubs	<CIasinl>
    MakeStubs	<CIacosl>
    MakeStubs	<CIatanl>
    MakeStubs	<CIatan2l>

elseifdef  _TRIGHL_
    MakeStubs	<CIsinhl>
    MakeStubs	<CIcoshl>
    MakeStubs	<CItanhl>

elseifdef  _FLOORL_
    MakeStubs	<CIfloorl>

elseifdef  _FMODL_
    MakeStubs	<CIfmodl>

elseifdef  _MINMAX_
    MakeStubs	<CImax>
    MakeStubs	<CImin>

elseifdef  _FLD1_
    MakeStubs	<fld1>

else
    %out  Error: No function name was defined.
    .err
endif

sEnd  code
end
