################################################################################
#
#   makefile for c51stubs.lib.
#
################################################################################


SRCDIR = .
OBJDIR = ..\hobjs


ASM = masm -t -Mx -W2
LIBEXE = lib

OBJS = \
	$(OBJDIR)\c51chkst.obj	\
	$(OBJDIR)\c51ftol.obj	\
	$(OBJDIR)\c51fcom.obj	\
	$(OBJDIR)\c51ccll.obj	\
	$(OBJDIR)\c51ccllf.obj	\
	$(OBJDIR)\c51cclls.obj	\
	$(OBJDIR)\c51fcll.obj	\
	$(OBJDIR)\c51ceil.obj	\
	$(OBJDIR)\c51sqrt.obj	\
	$(OBJDIR)\c51tran.obj	\
	$(OBJDIR)\c51trig.obj	\
	$(OBJDIR)\c51triga.obj	\
	$(OBJDIR)\c51trigh.obj	\
	$(OBJDIR)\c51floor.obj	\
	$(OBJDIR)\c51fmod.obj	\
	$(OBJDIR)\c51fabs.obj	\
	$(OBJDIR)\c51ceill.obj	\
	$(OBJDIR)\c51sqrtl.obj	\
	$(OBJDIR)\c51tranl.obj	\
	$(OBJDIR)\c51trgl.obj	\
	$(OBJDIR)\c51trgal.obj	\
	$(OBJDIR)\c51trghl.obj	\
	$(OBJDIR)\c51florl.obj	\
	$(OBJDIR)\c51fmodl.obj	\
	$(OBJDIR)\c51mnmx.obj	\
	$(OBJDIR)\c51fld1.obj


$(OBJDIR)\c51stubs.lib: $(OBJS)
    if exist $@ erase $@
    $(LIBEXE) @<<
$(OBJDIR)\c51stubs.lib
y
+$(OBJS);
<<



$(OBJDIR)\c51chkst.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_CHKSTK_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51ftol.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FTOL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51fcom.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FCOM_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51ccll.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_CCALL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51ccllf.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_CCALLF_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51cclls.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_CCALLS_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51fcll.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FCALL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51ceil.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_CEIL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51sqrt.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_SQRT_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51tran.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRAN_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51trig.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRIG_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51triga.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRIGA_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51trigh.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRIGH_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51floor.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FLOOR_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51fmod.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FMOD_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51fabs.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FABS_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51ceill.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_CEILL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51sqrtl.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_SQRTL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51tranl.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRANL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51trgl.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRIGL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51trgal.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRIGAL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51trghl.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_TRIGHL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51florl.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FLOORL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51fmodl.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FMODL_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51mnmx.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_MINMAX_ $(SRCDIR)\c51stubs.asm,$@;

$(OBJDIR)\c51fld1.obj: $(SRCDIR)\c51stubs.asm
    $(ASM) -D_FLD1_ $(SRCDIR)\c51stubs.asm,$@;
