	page	,132
	title	hdiff - huge address difference
;***
;hdiff.asm - huge address difference
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines the huge pointer difference routines
;	routines created:
;	    __aFahdiff	(large, medium model)
;	    __aNahdiff	(small, compact model)
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include mm.inc
	include cmphlp.inc
	.list

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;hdiff - Helper to compute difference of two huge pointers
;
;Purpose:
;	A call to this helper routine is generated by the compiler when
;	a huge addresses is subtracted from another.  The "C" language
;	defines that the difference of two pointers is an integer, but
;	for huge pointers this is not adequate -- a long is needed.
;
;	This routine computes the difference between the 3 huge addresses
;	in 8086 20-bit linear address real mode.  A 20-bit real-mode
;	address is computed by adding the offset portion to 16 times the
;	segment portion.  This code finds the difference between the
;	segment parts, makes this a signed long, multiplies that by 16 to	 add then adds the difference of the offset parts.
;	linearize that segment difference, and then adds in the difference
;	between the offsets.  This is faster than linearizing each address
;	and finding the difference between the 20-bit linearized values.
;	Note that the difference in segments must be extended to a long
;	BEFORE it is multiplied by 16.	Otherwise the sign bit will not
;	be properly propogated, and negative differences will be wrong!
;
;	hugediff(SegA:OffA,SegB:OffB) = (16*SegA + OffA) - (16*SegB + OffB)
;				      = 16*(SegA - SegB) + (OffA - OffB)
;
;
;Entry:
;	Two huge pointers on the stack (8 bytes total)
;		1st pushed: pointer A (DWORD)
;		2nd pushed: pointer B (DWORD)
;
;Exit:
;	DX:AX contains the difference between the two huge pointers (A-B)
;	NOTE: The parameters are removed from the stack by this routine.
;
;Uses:
;	AX, DX
;
;Exceptions:
;
;*******************************************************************************

if	sizeC
cProc	_aFahdiff,<PUBLIC>,<>	; far code
else
cProc	_aNahdiff,<PUBLIC>,<>	; near code
endif
	parmd	a
	parmd	b
cBegin
	mov	ax,SEG_a
	sub	ax,SEG_b
	sbb	dx,dx		; difference of the segments

	REPT	4
	add	ax,ax		; left shift DX:AX by 4
	adc	dx,dx		; to linearize segment difference
	ENDM

	add	ax,OFF_a	; add in difference of offsets
	adc	dx,0
	sub	ax,OFF_b
	sbb	dx,0

cEnd	nolocals
return	8			; clean up parameters on stack

sEnd

	end
