	page	,132
	title	ldiv - signed long divide routine
;***
;ldiv.asm - signed long divide routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines the signed long divide routine
;	the following routines are created:
;	    __aFldiv	(large, medium models)
;	    __aNldiv	(small, compact models)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include cmphlp.inc
include mm.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;ldiv - signed long divide
;
;Purpose:
;	Does a signed long divide of the arguments.  Arguments are
;	not changed.
;
;Entry:
;	Arguments are passed on the stack:
;		1st pushed: divisor (DWORD)
;		2nd pushed: dividend (DWORD)
;
;Exit:
;	DX:AX contains the quotient (dividend/divisor)
;	NOTE: this routine removes the parameters from the stack.
;
;Uses:
;	CX
;
;Exceptions:
;
;*******************************************************************************

	ASGN	ldiv

	push	di
	push	si
	push	bx

; Set up the local stack and save the index registers.	When this is done
; the stack frame will look as follows (assuming that the expression a/b will
; generate a call to ldiv(a, b)):
;
;		-----------------
;		|		|
;		|---------------|
;		|		|
;		|--divisor (b)--|
;		|		|
;		|---------------|
;		|		|
;		|--dividend (a)-|
;		|		|
;		|---------------|
;		| return addr** |
;		|---------------|
;	BP----->|    old BP	|
;		|---------------|
;		|      DI	|
;		|---------------|
;		|      SI	|
;		|---------------|
;	SP----->|      BX	|
;		-----------------
;
; ** - 2 bytes if small/compact model; 4 bytes if medium/large model

DVND	equ	BPARGBAS[bp]	; stack address of dividend (a)
DVSR	equ	BPARGBAS+4[bp]	; stack address of divisor (b)


; Determine sign of the result (di = 0 if result is positive, non-zero
; otherwise) and make operands positive.

	xor	di,di		; result sign assumed positive

	mov	ax,HIWORD(DVND) ; hi word of a
	or	ax,ax		; test to see if signed
	jge	L1		; skip rest if a is already positive
	inc	di		; complement result sign flag
	mov	dx,LOWORD(DVND) ; lo word of a
	neg	ax		; make a positive
	neg	dx
	sbb	ax,0
	mov	HIWORD(DVND),ax ; save positive value
	mov	LOWORD(DVND),dx
L1:
	mov	ax,HIWORD(DVSR) ; hi word of b
	or	ax,ax		; test to see if signed
	jge	L2		; skip rest if b is already positive
	inc	di		; complement the result sign flag
	mov	dx,LOWORD(DVSR) ; lo word of a
	neg	ax		; make b positive
	neg	dx
	sbb	ax,0
	mov	HIWORD(DVSR),ax ; save positive value
	mov	LOWORD(DVSR),dx
L2:

;
; Now do the divide.  First look to see if the divisor is less than 64K.
; If so, then we can use a simple algorithm with word divides, otherwise
; things get a little more complex.
;
; NOTE - ax currently contains the high order word of DVSR
;

	or	ax,ax		; check to see if divisor < 64K
	jnz	L3		; nope, gotta do this the hard way
	mov	cx,LOWORD(DVSR) ; load divisor
	mov	ax,HIWORD(DVND) ; load high word of dividend
	xor	dx,dx
	div	cx		; ax <- high order bits of quotient
	mov	bx,ax		; save high bits of quotient
	mov	ax,LOWORD(DVND) ; dx:ax <- remainder:lo word of dividend
	div	cx		; ax <- low order bits of quotient
	mov	dx,bx		; dx:ax <- quotient
	jmp	short L4	; set sign, restore stack and return

;
; Here we do it the hard way.  Remember, ax contains the high word of DVSR
;

L3:
	mov	bx,ax		; bx:cx <- divisor
	mov	cx,LOWORD(DVSR)
	mov	dx,HIWORD(DVND) ; dx:ax <- dividend
	mov	ax,LOWORD(DVND)
L5:
	shr	bx,1		; shift divisor right one bit
	rcr	cx,1
	shr	dx,1		; shift dividend right one bit
	rcr	ax,1
	or	bx,bx
	jnz	L5		; loop until divisor < 64K
	div	cx		; now divide, ignore remainder
	mov	si,ax		; save quotient

;
; We may be off by one, so to check, we will multiply the quotient
; by the divisor and check the result against the orignal dividend
; Note that we must also check for overflow, which can occur if the
; dividend is close to 2**32 and the quotient is off by 1.
;

	mul	word ptr HIWORD(DVSR) ; QUOT * HIWORD(DVSR)
	xchg	cx,ax		; "mov cx,ax" but only 1 byte
	mov	ax,LOWORD(DVSR)
	mul	si		; QUOT * LOWORD(DVSR)
	add	dx,cx		; DX:AX = QUOT * DVSR
	jc	L6		; carry means Quotient is off by 1

;
; do long compare here between original dividend and the result of the
; multiply in dx:ax.  If original is larger or equal, we are ok, otherwise
; subtract one (1) from the quotient.
;

	cmp	dx,HIWORD(DVND) ; compare hi words of result and original
	ja	L6		; if result > original, do subtract
	jb	L7		; if result < original, we are ok
	cmp	ax,LOWORD(DVND) ; hi words are equal, compare lo words
	jbe	L7		; if less or equal we are ok, else subtract
L6:
	dec	si		; subtract 1 from quotient
L7:
	xor	dx,dx		; dx:ax <- quotient
	xchg	ax,si		; "mov ax,si" but only 1 byte

;
; Just the cleanup left to do.	dx:ax contains the quotient.  Set the sign
; according to the save value, cleanup the stack, and return.
;

L4:
	dec	di		; check to see if result is negative
	jnz	L8		; if DI == 0, result should be negative
	neg	dx		; otherwise, negate the result
	neg	ax
	sbb	dx,0

;
; Restore the saved registers and return.
;

L8:
	pop	bx
	pop	si
	pop	di

cEnd	<nolocals>
return	8

sEnd

	end
