	page	,132
	title	llrot - long rotate left
;***
;llrot.asm - long rotate left
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	define long rotate left routines (signed and unsigned are same)
;	defines the following routines:
;	    __aFllrot	 (medium, large model)
;	    __aNllrot	 (small, compact model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;llrot - long rotate left
;
;Purpose:
;	Does a Long Rotate Left (signed and unsigned are identical)
;	Rotates a long left any number of bits.
;
;Entry:
;	DX:AX - long value to be rotated
;	CX    - number of bits to rotate by
;
;Exit:
;	DX:AX - rotated value
;
;Uses:
;	CX is destroyed.
;
;Exceptions:
;
;*******************************************************************************

if	sizeC
	cProc	_aFllrot,<PUBLIC>,<>
else
	cProc	_aNllrot,<PUBLIC>,<>
endif
	cBegin	nogen


if	?WIN
	if	sizeC
	inc	bp
	push	bp
	endif
endif


;
; Rotate count is only significant mod 32
;

	and	cx,001FH	; shift count mod 32
	jcxz	L2		; return if shift count is zero

;
; The shift loop.
;

L1:
	shl	ax,1		; lo word; propagate 0 (zero); carry <- hi bit
	rcl	dx,1		; hi word; lo bit <- carry; carry <- hi bit
	adc	ax,0		; lo word; lo bit <- carry
	loop	L1		; decrement shift count (cx) and loop if not 0

;
; Execute correct return
;

L2:
if	?WIN
	if	sizeC
	pop	bp
	dec	bp
	endif
endif
	ret

cEnd	nogen

sEnd

	end
