	page	,132
	title	lrrot - long rotate right
;***
;lrrot.asm - long rotate right
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	define long rotate right routines (signed and unsigned are same)
;	defines the following routines:
;	    __aFlrrot	 (medium, large model)
;	    __aNlrrot	 (small, compact model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;lrrot - long rotate right
;
;Purpose:
;	Does a Long Rotate Right (signed and unsigned are identical)
;	Rotates a long right any number of bits.
;
;Entry:
;	DX:AX - long value to be rotated
;	CX    - number of bits to rotate by
;
;Exit:
;	DX:AX - rotated value
;
;Uses:
;	CX is destroyed.
;
;Exceptions:
;
;*******************************************************************************

if	sizeC
	cProc	_aFlrrot,<PUBLIC>,<>
else
	cProc	_aNlrrot,<PUBLIC>,<>
endif
	cBegin	nogen


if	?WIN
	if	sizeC
	inc	bp
	push	bp
	endif
endif


;
; Rotate count is only significant mod 32
;

	and	cx,001FH	; shift count mod 32
	jcxz	L2		; return if shift count is zero

;
; The shift loop.
;
	push	bx		; save bx

L1:
	mov	bx,dx
	shr	bx,1		; copy hi word low bit -> carry
	rcr	ax,1		; lo word; carry -> hi bit; low bit -> carry
	rcr	dx,1		; hi word; carry -> hi bit
	loop	L1		; decrement shift count (cx) and loop if not 0

	pop	bx		; restore bx

;
; Execute correct return
;

L2:
if	?WIN
	if	sizeC
	pop	bp
	dec	bp
	endif
endif
	ret

cEnd	nogen

sEnd

	end
