	page	,132
	title	lshl - long shift left
;***
;lshl.asm - long shift left
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	define long shift left routines (signed and unsigned are same)
;	defines the following routines:
;	    __aFlshl	(medium, large model)
;	    __aNlshl	(small, compact model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;lshl - long shift left
;
;Purpose:
;	Does a Long Shift Left (signed and unsigned are identical)
;	Shifts a long left any number of bits.
;
;Entry:
;	DX:AX - long value to be shifted
;	CX    - number of bits to shift by
;
;Exit:
;	DX:AX - shifted value
;
;Uses:
;	CX is destroyed.
;
;Exceptions:
;
;*******************************************************************************

if	sizeC
	cProc	_aFlshl,<PUBLIC>,<>
else
	cProc	_aNlshl,<PUBLIC>,<>
endif
	cBegin	nogen


if	?WIN
	if	sizeC
	inc	bp
	push	bp
	endif
endif


;
; Ensure 1 <= shift count (cx) <= 255
;

	xor	ch,ch		; clear hi byte of shift count
	jcxz	L2		; return if shift count is zero

;
; The shift loop.
;

L1:
	shl	ax,1		; lo word; propagate 0 (zero); carry <- hi bit
	rcl	dx,1		; hi word; lo bit <- carry; hi bit is lost
	loop	L1		; decrement shift count (cx) and loop if not 0

;
; Execute correct return
;

L2:
if	?WIN
	if	sizeC
	pop	bp
	dec	bp
	endif
endif
	ret

cEnd	nogen

sEnd

	end
