	page	,132
	title	lshr - signed long shift right
;***
;lshr.asm - signed long shift right
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	define signed long shift right routines
;	defines the following routines:
;	    __aFlshr	(medium, large model)
;	    __aNlshr	(small, compact model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;lshr - signed long shift right
;
;Purpose:
;	Does a Signed Long Shift Right
;	Shifts a signed long right any number of bits.
;
;Entry:
;	DX:AX - long value to be shifted
;	CX    - number of bits to shift by
;
;Exit:
;	DX:AX - shifted value
;
;Uses:
;	CX is destroyed.
;
;Exceptions:
;
;*******************************************************************************

if	sizeC
	cProc	_aFlshr,<PUBLIC>,<>
else
	cProc	_aNlshr,<PUBLIC>,<>
endif
	cBegin	nogen

if	?WIN
	if	sizeC
	inc	bp
	push	bp
	endif
endif


;
; Ensure 1 <= shift count (cx) <= 255
;

	xor	ch,ch		; clear hi byte of shift count
	jcxz	L2		; return if shift count is zero

;
; The shift loop.
;

L1:
	sar	dx,1		; hi word; propagate sign bit; carry <- lo bit
	rcr	ax,1		; lo word; hi bit <- carry; lo bit is lost
	loop	L1		; decrement shift count (cx) and loop if not 0

;
; Execute correct return
;

L2:
if	?WIN
	if	sizeC
	pop	bp
	dec	bp
	endif
endif
	ret

cEnd	nogen

sEnd

	end
