	page	,132
	title	ulshr - unsigned long shift right
;***
;ulshr.asm - unsigned long shift right
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	define unsigned long shift right routines
;	defines the following routines:
;	    __aFulshr	 (medium, large model)
;	    __aNulshr	 (small, compact model)
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
include mm.inc
include cmphlp.inc
.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;ulshr - unsigned long shift right
;
;Purpose:
;	Does a Unsigned Long Shift Right
;	Shifts a unsigned long right any number of bits.
;
;Entry:
;	DX:AX - unsigned long value to be shifted
;	CX    - number of bits to shift by
;
;Exit:
;	DX:AX - shifted value
;
;Uses:
;	CX is destroyed.
;
;Exceptions:
;
;*******************************************************************************

if	sizeC
	cProc	_aFulshr,<PUBLIC>,<>
else
	cProc	_aNulshr,<PUBLIC>,<>
endif
	cBegin	nogen

if	?WIN
	if	sizeC
	inc	bp
	push	bp
	endif
endif


;
; Ensure 1 <= shift count (cx) <= 255
;

	xor	ch,ch		; clear hi byte of shift count
	jcxz	L2		; return if shift count is zero

;
; The shift loop.
;

L1:
	shr	dx,1		; hi word; propagate 0 (zero); carry <- lo bit
	rcr	ax,1		; lo word; hi bit <- carry; lo bit is lost
	loop	L1		; decrement shift count (cx) and loop if not 0

;
; Execute correct return
;

L2:
if	?WIN
	if	sizeC
	pop	bp
	dec	bp
	endif
endif
	ret

cEnd	nogen

sEnd

	end
