/***
*vecdtor.cxx - C++ destructor helper
*
*	Copyright (c) 1991-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*
*	NOTE:  The helper routines produced by this source must have
*	special names (i.e., not the "normal" C++ naming scheme).  Thus,
*	the build process involves producing .asm files, sed scripts, etc.
*
*******************************************************************************/

#include <stddef.h>

//	tm	this model				::= __near | __far | __huge
//	dm	dtor call model 		::= __near | __far
//	dtm	dtor this model 		::= __near | __far
//	vdm	__vec_dtor call model	::= __near | __far
//	nelems_t #elements type		::= ptrdiff_t | long

void pascal vdm vec_dtor(void tm* this_, size_t size, nelems_t eltCount,
			 void (pascal dm* dtor)(void dtm* this_))
{
	this_ = (char tm*)this_ + size*eltCount;
	while (--eltCount >= 0) {
		this_ = (char tm*)this_ - size;
		(*dtor)(this_);
	}
}
