	page	,132
	title	hdiff - huge address difference
;***
;hdiff.asm - OS/2 huge address difference
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Find huge address difference.
;	Routines defined:
;	    __aFahdiff	(large, medium model)
;	    __aNahdiff	(small, compact model)
;
;	[NOTE:	This source is used for both Windows and OS/2 libraries.]
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include mm.inc
	include cmphlp.inc
	.list

	extrn	__AHSHIFT:abs

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;hdiff - huge address difference
;
;Purpose:
;	Computes the difference between two huge pointers.  Note that the
;	scaling will be done in line by the caller.
;
;Entry:
;	The two address are passed on the stack:
;		1st pushed: address A (DWORD)
;		2nd pushed: address B (DWORD)
;
;Exit:
;	DX:AX - address difference (A - B)
;
;Uses:
;	AX, DX
;
;Exceptions:
;
;*******************************************************************************

if	sizeC			; far code
cProc	_aFahdiff,<PUBLIC>,<bx,cx>
else				; near code
cProc	_aNahdiff,<PUBLIC>,<bx,cx>
endif
	parmD	a
	parmD	b
cBegin
	mov	ax,OFF_a	; DX:AX = ptr A
	mov	dx,SEG_a

	mov	bx,SEG_b	; BX = selector of ptr B

	mov	cx,__AHSHIFT	; number of selector bits per 64K 'segment'
	shr	dx,cl		; linearize ptr A
	shr	bx,cl		; linearize ptr B
;
; DX and BX contain normalized selectors
;
	sub	ax,OFF_b
	sbb	dx,bx		; do long subtraction.

cEnd	nolocals
return	8

sEnd

	end
