;***
; convdll.inc - WLO DLL Startup Code
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	This file contains startup code used in WIN DLLs to make them
;	WLO compatible.
;
;	NOTES:
;	(1) This file must be included before __astart in the WIN DLL
;	startup code (e.g., between the cProc and cBegin declarations).
;
;	(2) In order to make a WIN DLL compatible with WLO, you must
;	run the convdll.exe tool over it:
;
;		convdll foo.dll
;
;	This allows the DLL to run under either Win 3.x or WLO.
;
;	(3) This code is taken directly from the WLO product.
;
;*******************************************************************************

WLOINITDLL      macro
                local cd_start, cd_patch, cd_init, WIN_NOP, WIN_PPLI
                local cd_end
         EXTRN   GETMODULEUSAGE:FAR
         EXTRN   INITTASK:FAR
         EXTRN   __WINFLAGS:abs

cd_start:
                push    ax
                push    bx
                push    cx
                push    dx
                push    es

                mov	ax, __WINFLAGS
                or	ax,ax
                jns     WIN_NOP

                pop     es
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                call    INITTASK-5
cd_patch:
                jmp     short cd_init
                nop
                xor     ax, ax
                retf
cd_init:        jmp     short cd_end

WIN_NOP:
                nop                         ; disable PPLI for Windows
                nop                         ;

                jmp     short WIN_PPLI
                push    di
                call    GETMODULEUSAGE
                dec     ax
                jz      WIN_PPLI
                inc     ax
                add     sp,10
                retf

WIN_PPLI:
                pop     es
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                jmp     short cd_end
                db      "C", "D", "D", 1, 0
		dw      cd_patch - cd_start
		dw      WIN_NOP - cd_start
		dw      cd_end - cd_start
cd_end:

endm
        WLOINITDLL
