;***
;fltintrn.inc - contains declarations of internal floating point types,
;		routines and variables
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	Declares floating point types, routines and variables used
;	internally by the C run-time.
;	[Internal]
;
;*******************************************************************************

if	sizeD

STRFLT	struc			; LARGE DATA model definition.
SF_sign		dw	?	; zero if positive otherwise negative
SF_decpt	dw	?	; exponent of floating point number
SF_flag		dw	?	; zero if okay otherwise IEEE overflow
SF_mantissa	dd	?	; pointer to mantissa in string form
STRFLT	ends

else

STRFLT	struc			; SMALL DATA model definition.
SF_sign		dw	?	; zero if positive otherwise negative
SF_decpt	dw	?	; exponent of floating point number
SF_flag		dw	?	; zero if okay otherwise IEEE overflow
SF_mantissa	dw	?	; pointer to mantissa in string form
STRFLT	ends

endif

FLT	struc
F_flags		dw	?	; Flag bits describing required result.
F_nbytes	dw	?	; Number of characters in string.
F_lval		dd	?	; For integer conversions.
F_dval		dq	?	; The returned floating point number.
FLT	ends

;	names for entries in table of pointers
;	to floating pointer helper routines

_cfltcvt	equ	<_cfltcvt_tab[0]>
_fassign	equ	<_cfltcvt_tab[1*CPSIZE]>
_cropzeros	equ	<_cfltcvt_tab[2*CPSIZE]>
_forcdecpt	equ	<_cfltcvt_tab[3*CPSIZE]>
_positive	equ	<_cfltcvt_tab[4*CPSIZE]>
_cldcvt 	equ	<_cfltcvt_tab[5*CPSIZE]>
_ldfassign	equ	<_cfltcvt_tab[6*CPSIZE]>
