;***
;math.inc - definitions used by float formatting routines.
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	This file contains definitions used by the formatting routines
;	[efg]cvt and _output and _input.  The value of CVTBUFSIZE is used
;	to dimension arrays used to hold the maximum size double
;	precision number plus some slop to aid in formatting.
;
;*******************************************************************************

CVTBUFSIZE =	309+40		;# of digits in max. dp value + slop

;
; definition of exception struct - this struct is passed to the matherr
; routine when a floating point exception is detected
;

if	sizeD

exception struc 		;LARGE DATA model definition.
etype	dw	?		;exception type - see below
fname	dd	?		;Name of function where error occured
arg1	dq	?		;first argument to function
arg2	dq	?		;second argument (if any) to function
retval	dq	?		;value to be returned by function
exception ends

else

exception struc 		;SMALL DATA model definition.
etype	dw	?		;exception type - see below
fname	dw	?		;Name of function where error occured
arg1	dq	?		;first argument to function
arg2	dq	?		;second argument (if any) to function
retval	dq	?		;value to be returned by function
exception ends

endif

;
; definition of a complex struct to be used by those who use cabs and
; want type checking on their argument
;

complex struc
x	dq	?		;Real part.
y	dq	?		;Imaginary part.
complex ends

;
; Constant definitions for the exception type passed in the exception
; struct.
;

DOMAIN	=	1		;argument domain error */
SING	=	2		;argument singularity */
OVERFLOW= 3			;overflow range error */
UNDERFLOW= 4			;underflow range error */
TLOSS	=	5		;total loss of precision */
PLOSS	=	6		;partial loss of precision */

EDOM	=	33
ERANGE	=	34
