;***
;os2dll.inc - DynaLib/Multi-thread parameter definitions
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;
;*******************************************************************************

_NFILE_ = 256		;maximum number of streams

;Lock table offsets
;------------------
;[NOTE: These values must coincide with the values in os2dll.h.]

;[NOTE: do not change _SIGNAL_LOCK without changing emulator's os2dll.inc.]
_SIGNAL_LOCK	equ	1	; lock for signal() and emulator SignalAddress
				; emulator uses \math\include\os2dll.inc

_IOB_SCAN_LOCK	equ	2	; _iob[] table lock
_TMPNAM_LOCK	equ	3	; lock global tempnam variables
_INPUT_LOCK	equ	4	; lock for _input() routine
_OUTPUT_LOCK	equ	5	; lock for _output() routine
_CSCANF_LOCK	equ	6	; lock for _cscanf() routine
_CPRINTF_LOCK	equ	7	; lock for _cprintf() routine
_CONIO_LOCK	equ	8	; lock for conio routines
_HEAP_LOCK	equ	9	; lock for heap allocator routines
_BHEAP_LOCK	equ	10	; lock for based heap routines
_TIME_LOCK	equ	11	; lock for time functions
_ENV_LOCK	equ	12	; lock for environment variables
_EXIT_LOCK1	equ	13	; lock #1 for exit code
_EXIT_LOCK2	equ	14	; lock #2 for exit code
_THREADDATA_LOCK equ	15	; lock for thread data table
_POPEN_LOCK	equ	16	; lock for _popen/_pclose database
_SSCANF_LOCK	equ	17	; lock for sscanf() iob
_SPRINTF_LOCK	equ	18	; lock for sprintf() iob
_VSPRINTF_LOCK	equ	19	; lock for vsprintf() iob
_STREAM_LOCKS	equ	20	; Table of stream locks

_LAST_STREAM_LOCK equ	(_STREAM_LOCKS+_NFILE_-1) ; Last stream lock

_FH_LOCKS	equ	(_LAST_STREAM_LOCK+1)	; Table of fh locks
_LAST_FH_LOCK	equ	(_FH_LOCKS+_NFILE_-1)	; Last fh lock

_TOTAL_LOCKS	equ	_LAST_FH_LOCK+1 	; Total number of locks




; Tid Table Definitions
; ---------------------


;Declarations
;------------

;Multi-thread Macros
;-------------------

;_mlock -- Aquire a lock
;Arg = lock number

_mlock		MACRO	locknum
		ENDM

;_munlock -- Release a lock
;Arg = lock number

_munlock	MACRO	locknum
		ENDM

;_mwait -- Wait for a lock but don't aquire it
;Arg = lock number

_mwait		MACRO	locknum
		ENDM

;_lock_fh -- Lock file handle
;Arg = file handle

_lock_fh	MACRO	fh
		ENDM

;_unlock_fh -- Unlock file handle
;Arg = register containing file handle

_unlock_fh	MACRO	fh
		ENDM

;_unlock_fh_check -- Unlock file handle if flag is set
;Args:	reg = register to use in the macro (e.g., ax)
;	file = file handle (e.g., bx or [fh])
;	flag = lock/unlock flag (e.g., [lock_flag])
;	       (0 = no lock/unlock operation)

_unlock_fh_check MACRO	reg,file,flag
		ENDM

;_lock_fh_check -- Lock file handle if flag is set
;Args:	reg = register to use in the macro (e.g., ax)
;	file = file handle (e.g., bx or [fh])
;	flag = lock/unlock flag (e.g., [lock_flag])
;		(0 = no lock/unlock operation)

_lock_fh_check	MACRO	reg,file,flag
		ENDM

;_lock_str -- Acquire stream lock
;Arg:	str = index of stream in _iob[]

_lock_str	MACRO	str
		ENDM

;_unlock_str -- Unlock stream
;Arg:	str = index of stream in _iob[]

_unlock_str	MACRO	str
		ENDM

;_dll_mlock -- Aquire a lock (set/clear DS)
;Arg = lock number

IFDEF	_LOAD_DGROUP
_dll_mlock	MACRO	locknum
		ENDM
ENDIF

;_dll_munlock -- Release a lock (set/clear DS)
;Arg = lock number

IFDEF	_LOAD_DGROUP
_dll_munlock	MACRO	locknum
		ENDM
ENDIF
