;***
;signal.inc - definitions for signal functionality
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	The file contains definitions for using the signal functions.
;
;*******************************************************************************

;
;	Signal Action Codes
;
SIG_DFL 	equ	0	; terminate process on receipt
SIG_IGN 	equ	1	; ignore
SIG_GET 	equ	2	; signal is accepted
SIG_SGE 	equ	3	; sender gets error
SIG_ACK 	equ	4	; acknowledge received signal
;
RSCMAX	equ	SIG_IGN 	; Maximum real mode signal code
PSCMAX	equ	SIG_ACK 	; Maximum protect mode signal code
;
;	Signal Error
;
SIG_ERR equ	-1		; error on signal call
;
;	Signal Types
;
SIGHUP	equ	1		;Hangup.
SIGINT	equ	2		;Interrupt.
SIGQUIT equ	3		;System V quit signal.
SIGILL	equ	4		;Illegal instruction.
;SIGTRAP equ	5		;trace trap.
SIGIOT	equ	6		;IOT instruction.
SIGEMT	equ	7		;EMT instruction.
SIGFPE	equ	8		;Floating point exception.
SIGKILL equ	9		;Kill, can not be ignored.
SIGBUS	equ	10		;Bus error.
SIGSEGV equ	11		;Segmentation violation.
SIGSYS	equ	12		;Bad argument to system call.
SIGPIPE equ	13		;Write to pipe with no one to read it.
SIGALARM equ	14		;Alarm clock.
SIGTERM equ	15		;Software termination signal from kill.
SIGUSR1 equ	16		;User defined signal 1.
SIGUSR2 equ	17		;User defined signal 2.
SIGCLD	equ	18		;Death of a child.
SIGPWR	equ	19		;Power-Fail restart.
SIGUSR3 equ	20		;User defined signal 3.
SIGBREAK equ	21		;Ctrl-Break sequence.
SIGABRT equ	22		;Abnormal termination
;
;	Number of Signals
;
NSIG	equ	22		; Maximum number of signals
RNSIG	equ	6		; # signals supported in real mode
PNSIG	equ	10		; # signals supported in protect mode

;	Signal Table Structure
;
;MS/DOS 3 Signal table structure

entry	struc
	shfoff	dw	0	;current signal handling function: offset
	shfseg	dw	0	;current signal handling function: segment
entry	ends

SIGTABSIZ EQU	4		;size of an entry structure


;OS/2 Signal table structure

entry5	struc
	sigoff	dw	0	;current signal handling function: offset
	sigseg	dw	0	;current signal handling function: segment
	sigcode dw	0	;current signal action code
entry5	ends

SIGTABSIZ5 EQU	6		;size of an entry structure
