/***
*ios.cxx - fuctions for ios class.
*
*	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Functions for ios class.
*
*******************************************************************************/

#include <stdlib.h>
#include <iostream.h>
#pragma hdrstop

const long ios::basefield = (ios::dec | ios::oct | ios::hex);
const long ios::adjustfield = (ios::left | ios::right | ios::internal);
const long ios::floatfield = (ios::scientific | ios::fixed);

long ios::x_maxbit = 0x8000;	// ios::openprot
long  * ios::x_statebuf = NULL;
int  ios::x_curindex = -1;

/***
*ios::ios() - default constructor.
*
*Purpose:
*   Initializes an ios.
*
*Entry:
*
*Exit:
*
*Exceptions:
*
*******************************************************************************/

ios::ios()
{
    bp = NULL;
    state = ios::badbit;

    ispecial = 0;
    ospecial = 0;
    x_tie = (0);
    x_flags = 0;
    x_precision = 6;
    x_fill = ' ';
    x_width = 0;
    x_delbuf = 0;
}



/***
*ios::ios( streambuf* pSB ) - constructor.
*
*Purpose:
*   Initializes an ios.
*
*Entry:
*
*Exit:
*
*Exceptions:
*
*******************************************************************************/

ios::ios( streambuf* pSB )
{
//  this->ios();

    bp = pSB;
    state = (bp) ? 0 : ios::badbit;

    ispecial = 0;
    ospecial = 0;
    x_tie = (0);
    x_flags = 0;
    x_precision = 6;
    x_fill = ' ';
    x_width = 0;
    x_delbuf = 0;
}

/***
*ios::ios(const ios& _strm) - copy constructor.
*
*Purpose:
*	Copy constructor.
*
*Entry:
*	_strm = ios to copy data members from.
*
*Exit:
*
*Exceptions:
*
*******************************************************************************/
ios::ios(const ios& _strm)	// copy constructor
{
    bp = NULL;
    x_delbuf = 0;

//  init(_strm.rdbuf());
//  delbuf(_strm.delbuf());

    *this = _strm;		// invoke assignment operator
//  state = (bp) ? 0 : ios::badbit;
}


/***
*virtual ios::~ios() - default destructor.
*
*Purpose:
*   Terminates an ios.
*
*Entry:
*
*Exit:
*
*Exceptions:
*
*******************************************************************************/

ios::~ios()
{
    if ((x_delbuf) && (bp))
	delete bp;
    bp = NULL;
    state = badbit;

}


/***
*void ios::init( streambuf* pSB ) - initializes ios
*
*Purpose:
*   Initializes an ios.
*
*Entry:
*
*Exit:
*
*Exceptions:
*
*******************************************************************************/

void ios::init( streambuf* pSB )
{
    if (delbuf() && (bp))	// delete previous bp if necessary
	delete bp;
    bp = pSB;
    if (bp)
	state &= ~ios::badbit;
    else
	state |= ios::badbit;
}



/***
*ios& ios::operator=( const ios& _strm ) - copy an ios.
*
*Purpose:
*   Copy an ios.
*
*Entry:
*
*Exit:
*
*Exceptions:
*
*******************************************************************************/

ios& ios::operator=(const ios& _strm)
{
	x_tie = _strm.tie();
	x_flags = _strm.flags();
	x_precision = (char)_strm.precision();
	x_fill	= _strm.fill();
	x_width = (char)_strm.width();

	state = _strm.rdstate();
	if (!bp)
	    state |= ios::badbit;	// adjust state for uninitialized bp

//	init(_strm.rdbuf());
//	delbuf(_strm.delbuf());

	return *this;
}

/***
*int ios::xalloc() - ios xalloc member function
*
*Purpose:
*	UNDONE:
*
*Entry:
*	None.
*
*Exit:
*	Returns index of of new entry in new buffer, or EOF if error.
*
*Exceptions:
*	Returns EOF if OM error.
*
*******************************************************************************/
int  ios::xalloc()
{
    long * tptr;
    int i;

    if (!(tptr=new long[x_curindex+2]))	// allocate new buffer
	return EOF;

    for (i=0; i <= x_curindex; i++)	// copy old buffer, if any
	tptr[i] = x_statebuf[i];

    tptr[++x_curindex] = 0L;		// init new entry, bump size

    if (x_statebuf)			// delete old buffer, if any
	delete x_statebuf;
    x_statebuf = tptr;			// and assign new buffer

    return x_curindex;
}

/***
*long ios::bitalloc() - ios bitalloc member function
*
*Purpose:
*	Returns a unused bit mask for flags().
*
*Entry:
*	None.
*
*Exit:
*	Returns next available bit maskf.
*
*Exceptions:
*
*******************************************************************************/
long ios::bitalloc() { return x_maxbit<<=1; }	// CONSIDER: make inline?
