/***
* istream.cxx - definitions for istream and istream_withassign classes
*
*	Copyright (c) 1991-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Definitions of member functions for istream and istream_withassign
*	classes.
*	[AT&T C++]
*
*******************************************************************************/

#include <internal.h>
#include <stdlib.h>
#include <ctype.h>
#include <iostream.h>
#pragma hdrstop

	istream::istream()
// : ios()
{
	x_flags |= ios::skipws;
	x_gcount = 0;
	_fGline = 0;
	// CONSIDER: do anything else?
}

	istream::istream(streambuf* _inistbf)
// : ios()
{
	init(_inistbf);

	x_flags |= ios::skipws;
	x_gcount = 0;
	_fGline = 0;
	// CONSIDER: do anything else?
}

	istream::istream(const istream& _istrm)
// : ios()
{
	init(_istrm.rdbuf());

	x_flags |= ios::skipws;
	x_gcount = 0;
	_fGline = 0;
	// CONSIDER: do anything else?
}

	istream::~istream()
// : ~ios()
{
	// CONSIDER: do anything else?
}

// used by ios::sync_with_stdio()
istream& istream::operator=(streambuf * _sbuf)
{
// consider: may be some redundency here, depending on spec.
	if (delbuf() && rdbuf())
	    delete rdbuf();
	bp = 0;

	this->ios::operator=(ios());	// initialize ios members
	delbuf(0);			// important!
	init(_sbuf);	// set up bp

	x_flags |= ios::skipws;		// init istream members too
	x_gcount = 0;
//	_fGline = 0;			// not necessary

	return *this;
}
int istream::ipfx(int need)
{
    if (need)		// reset gcount if unformatted input
	x_gcount = 0;
    if (state)		// return 0 iff error condition
	{
	state |= ios::failbit;	// solves cin>>buf problem
	return 0;
	}
    if (x_tie && ((need==0) || (need > bp->in_avail())))
	{
	x_tie->flush();
	}
    if ((need==0) && (x_flags & ios::skipws))
	{
	eatwhite();
	if (state)	// eof or error
	    {
	    state |= ios::failbit;
	    return 0;
	    }
	}
    return 1;		// return nz if okay
}

// formatted input functions

istream& istream::operator>>(char * s)
{
    int c;
    unsigned int i, lim;
    if (ipfx(0))
	{
	lim = (unsigned)(x_width-1);
	x_width = 0;
	if (!s)
	    {
	    state |= ios::failbit;
	    }
	else
	    {
	    for (i=0; i< lim; i++)
		{
		c=bp->sgetc();
		if (c==EOF)
		    {
		    state |= ios::eofbit;
		    if (!i)
			state |= ios::failbit|ios::badbit;
		    break;
		    }
		else if (isspace(c))
		    {
		    break;
		    }
		else
		    {
		    s[i] = (char)c;
		    bp->stossc(); // advance pointer
		    }
	        }
	    if (!i)
		state |= ios::failbit;
	    else
		s[i] = '\0';
	    }
	isfx();
	}
    return *this;
}

#if 0
istream& istream::operator>>(char& c)
{
    int tchar;
    if (ipfx(0))
	{
	tchar=bp->sbumpc();
	if (tchar==EOF)
	    {
	    state |= ios::eofbit|ios::badbit;
	    }
	else
	    {
	    c = (char)tchar;
	    }
	isfx();
	}
    return *this;
}
#endif

int istream::peek()
{
    return (ipfx(1)) ? (bp->sgetc()) : EOF;
    // UNDONE: call isfx()
}

istream& istream::putback(char c)
{
//    if (!bad())		// CONSIDER: just return if bad error?
      if (good())		// this is how it's spec.ed out...
	{
	if (bp->sputbackc(c)==EOF)
	    state |= ios::failbit;
//	else
//	    state &= ~(ios::eof); // no longer at end of file, if we were...
	}
    return *this;
}

int istream::sync()
{
    int retval;
#ifdef	_BOGUS
    return 0;
#else
    if ((retval=bp->sync())==EOF)
	state |= ios::failbit|ios::badbit;
    return retval;
#endif
}

void istream::eatwhite()
{
    int c;
    c = bp->sgetc();
    for ( ; ; )
	{
	if (c==EOF)
	    {
	    state |= ios::eofbit;
	    break;
	    }
	if (isspace(c))
	    {
	    c = bp->snextc();
	    }
	else
	    {
	    break;
	    }
	}
}
	istream_withassign::istream_withassign()
: istream()
{
	// CONSIDER: do anything else?
}

	istream_withassign::istream_withassign(streambuf* _is)
: istream(_is)
{
	// CONSIDER: do anything else?
}

	istream_withassign::~istream_withassign()
// : ~istream()
{
	// CONSIDER: do anything else?
}
