/***
* istrint.cxx - definitions for istream class operaotor>>(int) member functions
*
*	Copyright (c) 1991-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Definitions of operator>>(int) member function(s) for istream class.
*	[AT&T C++]
*
*******************************************************************************/

#include <internal.h>
#include <stdlib.h>
#include <limits.h>
#include <iostream.h>
#pragma hdrstop

// CONSIDER: validify all this maximum length
#define MAXLONGSIZ	16

/***
*istream& istream::operator>>(int& n) - extract int
*
*Purpose:
*	Extract int value from stream
*
*Entry:
*	n = value to update
*
*Exit:
*	n updated, or ios::failbit & n=INT_MAX/INT_MIN on overflow/underflow
*
*Exceptions:
*	Stream error on entry or value out of range
*
*******************************************************************************/
istream& istream::operator>>(int& n)
{
_WINSTATIC char ibuffer[MAXLONGSIZ];
    long value;
    char ** endptr = (char**)NULL;
    if (ipfx(0))
	{
	value = strtol(ibuffer, endptr, getint(ibuffer));
	if (value>INT_MAX)
	    {
	    n = INT_MAX;
	    state |= ios::failbit;
	    }
	else if (value<INT_MIN)
	{
	    n = INT_MIN;
	    state |= ios::failbit;
	    }
	else
	    n = (int) value;
#if 0
	if (**endptr)
	    {
	    // UNDONE: put back any unread characters, if possible
	    }
#endif
        isfx();
	}
return *this;
}
