/***
* ostream.cxx - definitions for ostream and ostream_withassign classes
*
*	Copyright (c) 1991-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Contains the core member function definitions for ostream and
*	ostream_withassign classes.
*
*******************************************************************************/

#include <internal.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#pragma hdrstop

int ostream::opfx()
{
    if (state)
	{
	state |= ios::failbit;	// CONSIDER???
	return 0;
	}
    if (x_tie)
	{
	x_tie->flush();
	}
    return(1);	// return non-zero
}

void ostream::osfx()
{
    x_width = 0;
    if (x_flags & unitbuf)
	{
	if (bp->sync()==EOF)
	    state = failbit | badbit;
	}
#ifndef	_WINDLL
    if (x_flags & ios::stdio)
	{
	if (fflush(stdout)==EOF)
	    state |= failbit;
	if (fflush(stderr)==EOF)
	    state |= failbit;
	}
#endif
}

// note: called inline by char and signed char versions:
#if 0
ostream&  ostream::operator<<(unsigned char c)
{
    if (opfx())
	{
	if (x_width)
	    {
	    _WINSTATIC char outc[2];
	    outc[0] = c;
	    outc[1] = '\0';
	    writepad("",outc);
	    }
	else if (bp->sputc(c)==EOF)
	    {
	    if (bp->overflow(c)==EOF)
		state |= (badbit|failbit);  // fatal error?
	    }
	osfx();
	}
    return *this;
}
#endif

// note: called inline by unsigned char * and signed char * versions:
ostream& ostream::operator<<(const char * s)
{
    if (opfx()) {
	writepad("",s);
	osfx();
    }
    return *this;
}

ostream& ostream::flush()
{
    if (bp->sync()==EOF)
	state |= ios::failbit;
    return(*this);
}

	ostream::ostream()
// : ios()
{
	x_floatused = 0;
	// CONSIDER: do anything else?
}

	ostream::ostream(streambuf* _inistbf)
// : ios()
{
	init(_inistbf);

	x_floatused = 0;
	// CONSIDER: do anything else?
}

	ostream::ostream(const ostream& _ostrm)
// : ios()
{
	init(_ostrm.rdbuf());

	x_floatused = 0;
	// CONSIDER: do anything else?
}

	ostream::~ostream()
// : ~ios()
{
	// CONSIDER: do anything else?
}

// used in ios::sync_with_stdio()
ostream& ostream::operator=(streambuf * _sbuf)
{
// consider: may be some redundency here, depending on spec.

	if (delbuf() && rdbuf())
	    delete rdbuf();
	bp = 0;

	this->ios::operator=(ios());	// initialize ios members
	delbuf(0);			// important!
	init(_sbuf);

//	x_floatused = 0;		// not necessary

	return *this;
}


	ostream_withassign::ostream_withassign()
: ostream()
{
	// CONSIDER: do anything else?
}

	ostream_withassign::ostream_withassign(streambuf* _os)
: ostream(_os)
{
	// CONSIDER: do anything else?
}

	ostream_withassign::~ostream_withassign()
// : ~ostream()
{
;	// CONSIDER: do anything else?
}

ostream& ostream::writepad(const char * leader, const char * value)

	{
unsigned int len, leadlen;
long padlen;
	leadlen = strlen(leader);
	len = strlen(value);
	padlen = (((unsigned)x_width) > (len+leadlen)) ? ((unsigned)x_width) - (len + leadlen) : 0;
	if (!(x_flags & (left|internal)))  // default is right-adjustment
	    {
	    while (padlen-- >0)
		{
		if (bp->sputc((unsigned char)x_fill)==EOF)
		    state |= (ios::failbit|ios::badbit);
		}
	    }
	if (leadlen)
	    {
	    if ((unsigned)bp->sputn(leader,leadlen)!=leadlen)
	        state |= (failbit|badbit);	// CONSIDER: right error?
	    }
	if (x_flags & internal)
	    {
	    while (padlen-- >0)
		{
		if (bp->sputc((unsigned char)x_fill)==EOF)
		    state |= (ios::failbit|ios::badbit);
		}
	    }
	if ((unsigned)bp->sputn(value,len)!=len)
	    state |= (failbit|badbit);	// CONSIDER: right error?
	if (x_flags & left)
	    {
	    while ((padlen--)>0)        // left-adjust if necessary
		{
		if (bp->sputc((unsigned char)x_fill)==EOF)
		    state |= (ios::failbit|ios::badbit);
		}
	    }
	return (*this);
	}
